% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transdistfuncs.r
\name{est.wt.matrix}
\alias{est.wt.matrix}
\title{Calculate the Infector-Infectee Wallinga-Teunis matrix}
\usage{
est.wt.matrix(case.times, gen.t.dist, basic.wt.weights = NULL)
}
\arguments{
\item{case.times}{a vector giving the occurrence time for each case}

\item{gen.t.dist}{a vector giving the generation time distribution for the infecting pathogen}

\item{basic.wt.weights}{a matrix giving the basic normalized Wallinga-Teunis weights for each time step (output from the \code{est.wt.matrix.weights} function). 
If this argument is \code{NULL} (the default), the basic Wallinga-Teunis matrix will be calculated automatically.}
}
\value{
a numerical matrix with the number of columns and rows equal to the number of cases in the epidemic
}
\description{
A function which takes the time of each case occurrence, the generation time distribution of the infecting pathogen, 
and the matrix of basic Wallinga-Teunis weights and estimates the probability that an infectee occurring time step j (columns) 
was infected by a case occurring at time i (rows).
}
\examples{
\donttest{

case.times <- c(1,2,2,3,3)
gen <- c(0, 2/3, 1/3, 0, 0)
t.density <- gen/sum(gen)

a <- est.wt.matrix(case.times=case.times, gen.t.dist=t.density)

}
}
\references{
Salje H, Cummings DAT and Lessler J (2016). “Estimating infectious disease transmission distances using the overall distribution of cases.” Epidemics, 17, pp. 10–18. ISSN 1755-4365, doi: \href{https://www.sciencedirect.com/science/article/pii/S1755436516300317}{10.1016/j.epidem.2016.10.001}.
}
\seealso{
Other est.wt: \code{\link{est.transdist}},
  \code{\link{est.wt.matrix.weights}}
}
\author{
John Giles, Justin Lessler, and Henrik Salje
}
\concept{est.wt}
