% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.pi}
\alias{get.pi}
\title{Generalized version of \code{get.pi}}
\usage{
get.pi(posmat, fun, r = 1, r.low = rep(0, length(r)), data.frame = TRUE)
}
\arguments{
\item{posmat}{a matrix with columns x, y and any other named columns
columns needed by \code{fun}}

\item{fun}{a function that takes in two rows of \code{posmat} and returns:
\enumerate{
     \item for pairs included in the numerator and denominator
     \item for pairs that should only be included in the denominator
     \item for pairs that should be ignored all together}
Note that names from \code{posmat} are not preserved in calls to \code{fun}, so the columns of the matrix should be
referenced numerically
so this is not available to the \code{fun}}

\item{r}{the series of spatial distances (or there maximums) we are
interested in}

\item{r.low}{the low end of each range, 0 by default}

\item{data.frame}{logical indicating whether to return results as a data frame (default = TRUE)}
}
\value{
pi value for each distance range that we look at. Where:

\deqn{ \pi(d_1, d_2) = \frac{\sum \boldsymbol{1} (d_{ij} \in [d_1,d_2)) \boldsymbol{1} (f(i,j)=1) }{\sum \sum \boldsymbol{1} [d_{ij} \in (d_1,d_2)) \boldsymbol{1} (f(i,j) \in \{1,2\}) }}
}
\description{
Generalized version of the \code{get.pi} function that takes in an arbitrary function and
returns the probability that a point within a particular range of a point of interest shares the relationship
specified by the passed in function with that point.
}
\examples{
\donttest{

data(DengueSimR02)

r.max<-seq(20,1000,20)
r.min<-seq(0,980,20)

sero.type.func<-function(a,b,tlimit=20){
  if(a[5]==b[5]&(abs(a[3]-b[3])<=tlimit)){rc=1}
  else{rc=2}
  return(rc)
}

sero.pi<-get.pi(DengueSimR02,sero.type.func,r=r.max,r.low=r.min)

}
}
\seealso{
Other get.pi: 
\code{\link{get.pi.bootstrap}()},
\code{\link{get.pi.ci}()},
\code{\link{get.pi.permute}()},
\code{\link{get.pi.typed.bootstrap}()},
\code{\link{get.pi.typed.permute}()},
\code{\link{get.pi.typed}()}

Other spatialtau: 
\code{\link{get.tau}()},
\code{\link{get.theta}()}
}
\author{
Justin Lessler and Henrik Salje
}
\concept{get.pi}
\concept{spatialtau}
