% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_scanFirst}
\alias{cpp_scanFirst}
\title{File Scanner}
\arguments{
\item{fname}{string, path to file.}

\item{target}{string, exact string to be searched for. At least 1 character and should not exceed 1024 characters.}

\item{start}{size_t, position where to begin search.
It can't be superior or equal than file size or end (when end is different from 0 and inferior than file size).}

\item{end}{size_t, position where to stop searching. Default is 0.
Search will end up at this position unless it is higher than file size.
In such case, search will end up when file end will be reached.}

\item{buf_size}{uint8_t, size of buffer used to search for target (in kilo-Bytes, will be forced to be between 2 and 1024). Default is 64.}
}
\value{
size_t index of first target character found within target plus 1 or 0 if not found.
}
\description{
Scans file for 1st occurence of a target string.
If found, it returns the position in bytes of the target.
Otherwise, it returns 0.
}
\keyword{internal}
