% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Psc.R
\name{Psc}
\alias{Psc}
\title{Proportion of interconnection}
\usage{
Psc(network.or.subnet_mat1, subnet_mat2 = NULL)
}
\arguments{
\item{network.or.subnet_mat1}{Either a multilayer(tripartite) network of 'igraph' class, or a numeric matrix(or data.frame) representing interactions between two groups of species. The network contains
interlayer links and without intralayer links. Each row and column of matrix represents the species in the first and second layers of the tripartite network respectively.
Elements of matrix are non-zero numebers if the interlayer species are connected, and 0 otherwise.}

\item{subnet_mat2}{A numeric matrix(or data.frame) representing interactions between two groups of species.Each row and column of matrix represents the species in the second and third layers of the
tripartite network respectively. Elements of matrix are non-zero numebers if the interlayer species are connected, and 0 otherwise. If \code{network.or.subnet_mat1} is "igraph", \code{subnet_mat2} defaults to NULL.}
}
\value{
Print a "PS_C= ;" and Return a numberic value representing the proportion of sharing species in intermediate layer.
}
\description{
Calculating the proportion of species sharing with other species of two subnetworks in intermediate layer.
}
\details{
\strong{network.or.subnet_mat1}
There are two types of data that can be processed:
(1). Input in a network of type "igraph" alone
(2). Must be entered as data frame or matrix with \code{subnet_mat2}

About a network of type "igraph", It can be obtained from the connection matrices of subnetworks by the function \code{igraph_from_matrices}
}
\examples{

set.seed(15)
d <- build_net(11,15,17,0.2)
Psc(d)

md1<-matrix(sample(c(0,1),100,replace=TRUE),10,10)
md2<-matrix(sample(c(0,1),120,replace=TRUE),10,12)
Psc(md1,md2)

mdw1<-matrix(sample(c(rep(0,40),runif(60,0,1))),10,10)
mdw2<-matrix(sample(c(rep(0,40),runif(80,0,1))),10,12)
Psc(mdw1,mdw2)

}
\references{
Domínguez-García, V., & Kéfi, S. (2021). The structure and robustness of tripartite ecological networks. bioRxiv, 2021-10.
}
