% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_interaction.R
\name{select_interaction}
\alias{select_interaction}
\title{Create tibble of all potential pressure combinations to test for interactions.}
\usage{
select_interaction(mod_tbl)
}
\arguments{
\item{mod_tbl}{A model output tibble from \code{\link{model_gam}},
\code{\link{select_model}}, \code{\link{merge_models}} or \code{\link{calc_deriv}}
representing the best model for each IND~pressure pair.}
}
\value{
The functions returns a tibble with three columns:
\describe{
  \item{\code{ind}}{The name of the indicator}
  \item{\code{press}}{The pressure name for the smooth term}
  \item{\code{t_var}}{The pressure name for the threshold variable}
}
}
\description{
\code{select_interaction} is a helper function that creates a tibble with
all indicator-specific combinations of pressures pairs as input for the
\code{\link{test_interaction}} function. The pressures in the IND~pressure
GAM(M)s are combined with all other pressures in the model tibble. If
specific combinations should not be modeled simply delete them from
this data frame.
}
\details{
For each IND~pressure pair specific pressures to test for interactions can
be selected by creating a tibble containing the IND (termed `ind`), the
pressure 1 (termed `press`) and the pressure 2 (termed `t_var`). The easiest
is to use the helper function \code{\link{select_interaction}}: it creates
all combinations of IND~press pairs and the threshold variables based on
the input model tibble. If specific combinations should not be modeled
simply delete them from this data frame.
}
\examples{
# Using some models of the Baltic Sea demo data
test <- select_interaction(mod_tbl = merge_models_ex[1:5,])
}
