% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataUtils.R
\name{outDetect}
\alias{outDetect}
\title{Detect outliers in a time series considering the raw data
and a smoothed version of it.}
\usage{
outDetect(x, weights = NULL, ff = c(7, 7))
}
\arguments{
\item{x}{numeric vector}

\item{weights}{non-increasing numeric vector used as weights for
computing a smoothed vector as a rooling window average.
Default is null and then \eqn{w_j} is proportional to j
in the equation in the Details below.}

\item{ff}{numeric length two vector with the factors
used to consider how many times the standard deviation
one data point is out to be considered as an outlier.}
}
\value{
logical vector indicating if the data is an outlier
with attributes as detailed bellow.
\itemize{
\item attr(, 'm') is the mean of x.
\item attr(, 's') is the standard devation of x.
\item attr(, 'ss') is the standard deviation for
the smoothed data \eqn{y_t} that is defined as
}

\eqn{y_t = \sum_{k=j}^h w_j * (x_{t-j}+x_{t+j})/2}

Both \code{s} and \code{ss} are used to define outliers if

\eqn{|x_t-m|/s>ff_1} or \eqn{|x_t-y_t|/ss>ff_2}
\itemize{
\item attr(, 'xs') the smoothed time series \eqn{y_t}
}
}
\description{
Detect outliers in a time series considering the raw data
and a smoothed version of it.
}
