% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drywetlong.R
\name{drywetlong}
\alias{drywetlong}
\title{Detects wet/dry long periods}
\usage{
drywetlong(x, ret = 300, sueco = 9.9, dry = TRUE, wet = TRUE)
}
\arguments{
\item{x}{vector with values}

\item{ret}{pseudo-return period (pareto-based) to compute the maximum tolerable spell}

\item{sueco}{threshold for dividing dry and wet. This is useful to label other binary sequences, e.g. for 0 radiation. Now it is <= and >, instead of < and >=}

\item{dry}{if set to TRUE, dry sequences are sent to result; if FALSE, omitted}

\item{wet}{same as previous, for wet sequences}
}
\value{
list of positions in the input data time series which do not pass QC test
}
\description{
This function detects episodes of too many consecutive wet or dry days
}
\examples{
#Extract the ECA&D data file from the example data folder
path2inptfl<-system.file("extdata", "RR_SOUID132730.txt", package = "INQC")
#Read the data file
x<-readecad(input=path2inptfl,missing= -9999)[,4:4]
#Find all suspicious positions in the precipitation time series
drywetlong(x,ret=300,sueco=9.9,dry=TRUE,wet=TRUE)

#Introduce the long wet period
x[1:600]<-10
#Find all suspicious positions in the precipitation time series
drywetlong(x,ret=300,sueco=9.9,dry=TRUE,wet=TRUE)
}
