% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{Plot.RT.ECDF_Per_Target}
\alias{Plot.RT.ECDF_Per_Target}
\alias{Plot.RT.ECDF_Per_Target.DataSetList}
\title{Plot the empirical cumulative distriburtion as a function of the running times of
a DataSetList at certain target function values}
\usage{
Plot.RT.ECDF_Per_Target(dsList, ftargets, scale.xlog = F)

\method{Plot.RT.ECDF_Per_Target}{DataSetList}(dsList, ftargets, scale.xlog = F)
}
\arguments{
\item{dsList}{A DataSetList (should consist of only one function and dimension).}

\item{ftargets}{The target function values}

\item{scale.xlog}{Whether or not to scale the x-axis logaritmically}
}
\value{
A plot of the empirical cumulative distriburtion as a function of
the running times of the DataSetList at the target function values
}
\description{
Plot the empirical cumulative distriburtion as a function of the running times of
a DataSetList at certain target function values
}
\examples{
Plot.RT.ECDF_Per_Target(subset(dsl, funcId == 1), 14)
}
