% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_overview.R
\name{item_overview}
\alias{item_overview}
\title{Item Overview}
\usage{
item_overview(
  data,
  squared = TRUE,
  file_name = "none",
  dpi = 500,
  color = NULL,
  font = "mono"
)
}
\arguments{
\item{data}{raw SEM estimates in the appropriate format, given by the input
functions.}

\item{squared}{logical; should factor loadings be squared?; defaults to TRUE}

\item{file_name}{character; name of the file to save. Supported formats are:
"pdf" (highest quality and smallest file size), "png", "jpeg"; defaults to
"none".}

\item{dpi}{integer; resolution in dots per inch for "png" and "jpeg" files;
defaults to 500.}

\item{color}{character; vector of hex codes for colors; defaults to the
colors "#DAD8D8" (gray), "#11C1FF" (light blue), and "#007AD6" (blue)}

\item{font}{character; font of the plot labels; defaults to "mono"}
}
\value{
gg / ggplot object; plot grid with one bar plot per item showing
  (squared) factor loadings of that item in all IPV models, arranged by
  facets and tests
}
\description{
Shows all (squared) factor loadings of all items in all models in a plot grid
of bar plots.
}
\details{
File output produces much more reliable results than display within
  R. Display within R may scatter elements of the chart and distort the
  overall appearance.
}
\examples{
# Honesty/Humility and Agreeableness items
# the use of file output is recommended
# to prevent irregular placement of plot labels
res <- ipv_est(
  HEXACO[1:1000,grep("^H_.*[1-4]$|^A_.*[1-4]$", names(HEXACO))],
  "HA")
# reduced to first 4 items per facet and first 1000 observations to reduce
# runtime
item_overview(res$est_raw) # file output is recommended (see details)


}
