% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_chart.R
\name{plot_items}
\alias{plot_items}
\title{Plot Items}
\usage{
plot_items(
  coord,
  size = 1,
  file_name = "none",
  file_width = 12,
  file_height = 10,
  zoom_x = NULL,
  zoom_y = NULL,
  dpi = 500,
  color = "black",
  color2 = "black",
  fade_axes = 50,
  fade_grid_major = 15,
  fade_grid_minor = 65,
  font = "sans",
  title = NULL,
  size_title = 1,
  size_tick_label = 1,
  size_test_label = 1,
  size_facet_labels = 1,
  width_axes = 1,
  size_arrow_heads = 1,
  width_items = 1,
  width_grid = 1
)
}
\arguments{
\item{coord}{list generated by \code{\link{coord_items}} or
\code{\link{coord_nested}}.}

\item{size}{integer; changes the size of most chart objects simultaneously.}

\item{file_name}{character; name of the file to save. Supported formats are:
"pdf" (highest quality and smallest file size), "png", "jpeg"; defaults to
"none".}

\item{file_width}{integer; file width in inches; defaults to 12.}

\item{file_height}{integer; file height in inches; defaults to 10.}

\item{zoom_x}{integer; vector with two values, the edges of the zoomed
section on the x-axis; defaults to NULL.}

\item{zoom_y}{integer; vector with two values, the edges of the zoomed
section on the y-axis; defaults to NULL.}

\item{dpi}{integer; resolution in dots per inch for "png" and "jpeg" files;
defaults to 500.}

\item{color}{first accent color; defaults to "black".}

\item{color2}{second accent color; defaults to "black".}

\item{fade_axes}{integer; brightness of the gray tone of the axes between 0 =
"black" and 100 = "white" in steps of 1; defaults to 50.}

\item{fade_grid_major}{integer; brightness of the gray tone of the major grid
lines between 0 = "black" and 100 = "white" in steps of 1; defaults to 15.}

\item{fade_grid_minor}{integer; brightness of the gray tone of the minor grid
lines between 0 = "black" and 100 = "white" in steps of 1; defaults to 65.}

\item{font}{character; text font, use extrafonts to access additional fonts;
defaults to "sans", which is "Helvetica".}

\item{title}{character; overall chart title; defaults to NULL.}

\item{size_title}{integer; title font size relative to default.}

\item{size_tick_label}{integer; axis tick label font size relative to
default.}

\item{size_test_label}{integer; test font size relative to default.}

\item{size_facet_labels}{integer; facet font size relative to default.}

\item{width_axes}{integer; radial axis width relative to default.}

\item{size_arrow_heads}{integer; arrow head size relative to default.}

\item{width_items}{integer; item bar width relative to default.}

\item{width_grid}{integer; grid line width relative to default.}
}
\value{
Object of the class "ggplot".
}
\description{
Generates an item chart from coordinates.
}
\details{
Use \code{\link{item_chart}} to create item charts.
}
\seealso{
\code{\link{coord_items}} \code{\link{item_chart}}
}
