% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.extra.calc_atm14c.R
\name{ISRaD.extra.calc_atm14c}
\alias{ISRaD.extra.calc_atm14c}
\title{ISRaD.extra.calc_atm14c}
\usage{
ISRaD.extra.calc_atm14c(database, future = TRUE)
}
\arguments{
\item{database}{ISRaD object}

\item{future}{Project atmospheric radiocarbon into the future?}
}
\value{
ISRaD_data object with new atmospheric zone and atmospheric 14C columns in relevant tables.
}
\description{
Calculates atmospheric 14c in the year of sampling for each record in an ISRaD object
}
\details{
Creates new column for atmospheric 14c (xxx_atm14c). Observation year and profile coordinates must be filled (use ISRaD.extra.fill_dates, and ISRaD.extra.fill_coords functions). The relevant atmospheric 14C data (northern or southern hemisphere) are determined by profile coordinates.\cr\cr
Atmospheric zones are limited to the northern or southern hemisphere, as differences in 14C in the source data (Hua et al., 2021) within either the northern or southern hemisphere are essentially zero after ~1980, and this is the period over which the majority of data in ISRaD were collected.\cr\cr
Future atmospheric 14C predictions for the period 2020 to 2025 are projected using a time series  model trained on data covering the period 2000-2019 (cf. Sierra, 2018).\cr\cr
}
\examples{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Fill profile coordinates
database.x <- ISRaD.extra.fill_coords(database)
# Fill dates
database.x <- ISRaD.extra.fill_dates(database.x)
# Fill delta 14C from fraction modern
database.x <- ISRaD.extra.fill_rc(database.x)
# Fill atmospheric 14c
database.x <- ISRaD.extra.calc_atm14c(database.x)
}
\references{
Hua, Q., Turnbull, J., Santos, G., Rakowski, A., Ancapichún, S., De Pol-Holz, R., . . . Turney, C. (2022). ATMOSPHERIC RADIOCARBON FOR THE PERIOD 1950–2019. Radiocarbon, 64(4), 723-745. doi:10.1017/RDC.2021.95
}
\author{
J. Beem-Miller and C. Hicks-Pries
}
