% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storedResults.R
\docType{data}
\name{obsSep2008}
\alias{obsSep2008}
\title{Observed sea ice September 2008}
\format{array of dimension of 2 years x 12 months x longitude x latitude}
\usage{
obsSep2008
}
\description{
The object \code{observed} is an binary matrix of dimension lon x lat that
indicates whether sea ice concentration was at least 15\%. The observations
are from the monthly sea ice concentration obtained from the National
Aeronautics and Space Administration (NASA) satellites Nimbus-7 SMMR and
DMSP SSM/I-SSMIS and processed by the bootstrap algorithm. The results are
distributed by the National Snow and Ice Data Center (Comiso 2017).
}
\examples{
data(obsSep2008)
dim(obsSep2008)
}
\references{
Comiso, J., 2017: Bootstrap sea ice concentrations
            from Nimbus-7 SMMR and DMSP SSM/I-SSMIS. version 3.
            Boulder, Colorado USA: NASA National Snow and Ice Data Center
            Distributed Active Archive Center.
            doi: \url{https://doi.org/10.5067/7Q8HCCWS4I0R}
}
\keyword{datasets}
