% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_indiv.r
\name{updateIndiv}
\alias{updateIndiv}
\title{Update individual COD probabilities from InSilicoVA Model Fits}
\usage{
updateIndiv(object, CI = 0.95, java_option = "-Xmx1g", ...)
}
\arguments{
\item{object}{Fitted \code{"insilico"} object.}

\item{CI}{Credible interval for posterior estimates.}

\item{java_option}{Option to initialize java JVM. Default to ``-Xmx1g'', which sets the maximum heap size to be 1GB.}

\item{\dots}{Not used.}
}
\value{
object Updated \code{"insilico"} object.
}
\description{
This function updates individual probabilities for each death and provide posterior credible intervals for each estimates.
}
\examples{
\dontrun{
data(RandomVA1)
fit1a<- insilico(RandomVA1, subpop = NULL,
                Nsim = 1000, burnin = 500, thin = 10 , seed = 1,
                auto.length = FALSE)
summary(fit1a, id = "d199")

# The following script updates credible interval for individual
fit1b <- updateIndiv(fit1a, CI = 0.95)
summary(fit1b, id = "d199")
}
}
\author{
Zehang Li, Tyler McCormick, Sam Clark

Maintainer: Zehang Li <lizehang@uw.edu>
}
\references{
Tyler H. McCormick, Zehang R. Li, Clara Calvert, Amelia C.
Crampin, Kathleen Kahn and Samuel J. Clark Probabilistic cause-of-death
assignment using verbal autopsies, \emph{arXiv preprint arXiv:1411.3042}
\url{http://arxiv.org/abs/1411.3042} (2014)
}
\seealso{
\code{\link{insilico}}, \code{\link{get.indiv}}
}

