/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.map.tlong.AbstractLongLongMap;
import cern.colt.map.tlong.OpenLongLongHashMap;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.SelectedSparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix3D;

public class SparseLongMatrix1D
extends LongMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongLongMap elements;

    public SparseLongMatrix1D(long[] lArray) {
        this(lArray.length);
        this.assign(lArray);
    }

    public SparseLongMatrix1D(int n) {
        this(n, n / 1000, 0.2, 0.5);
    }

    public SparseLongMatrix1D(int n, int n2, double d, double d2) {
        this.setUp(n);
        this.elements = new OpenLongLongHashMap(n2, d, d2);
    }

    protected SparseLongMatrix1D(int n, AbstractLongLongMap abstractLongLongMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = abstractLongLongMap;
        this.isNoView = false;
    }

    public LongMatrix1D assign(long l) {
        if (this.isNoView && l == 0L) {
            this.elements.clear();
        } else {
            super.assign(l);
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongLongMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public synchronized long getQuick(int n) {
        return this.elements.get((long)this.zero + (long)n * (long)this.stride);
    }

    public long index(int n) {
        return (long)this.zero + (long)n * (long)this.stride;
    }

    public LongMatrix1D like(int n) {
        return new SparseLongMatrix1D(n);
    }

    public LongMatrix2D like2D(int n, int n2) {
        return new SparseLongMatrix2D(n, n2);
    }

    public LongMatrix2D reshape(int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        SparseLongMatrix2D sparseLongMatrix2D = new SparseLongMatrix2D(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                long l;
                if ((l = this.getQuick(n3++)) == 0L) continue;
                ((LongMatrix2D)sparseLongMatrix2D).setQuick(j, i, l);
            }
        }
        return sparseLongMatrix2D;
    }

    public LongMatrix3D reshape(int n, int n2, int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        SparseLongMatrix3D sparseLongMatrix3D = new SparseLongMatrix3D(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    long l;
                    if ((l = this.getQuick(n4++)) == 0L) continue;
                    ((LongMatrix3D)sparseLongMatrix3D).setQuick(i, k, j, l);
                }
            }
        }
        return sparseLongMatrix3D;
    }

    public synchronized void setQuick(int n, long l) {
        long l2 = (long)this.zero + (long)n * (long)this.stride;
        if (l == 0L) {
            this.elements.removeKey(l2);
        } else {
            this.elements.put(l2, l);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("1 x ").append(this.size).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.size; ++i) {
            long l = this.getQuick(i);
            if (l == 0L) continue;
            stringBuilder.append('(').append(i).append(')').append('\t').append(l).append('\n');
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected boolean haveSharedCellsRaw(LongMatrix1D longMatrix1D) {
        if (longMatrix1D instanceof SelectedSparseLongMatrix1D) {
            SelectedSparseLongMatrix1D selectedSparseLongMatrix1D = (SelectedSparseLongMatrix1D)longMatrix1D;
            return this.elements == selectedSparseLongMatrix1D.elements;
        }
        if (longMatrix1D instanceof SparseLongMatrix1D) {
            SparseLongMatrix1D sparseLongMatrix1D = (SparseLongMatrix1D)longMatrix1D;
            return this.elements == sparseLongMatrix1D.elements;
        }
        return false;
    }

    protected LongMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseLongMatrix1D(this.elements, nArray);
    }
}

