/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.FloatIHistogram3D;
import hep.aida.tfloat.ref.FloatHistogram;

abstract class FloatAbstractHistogram3D
extends FloatHistogram
implements FloatIHistogram3D {
    private static final long serialVersionUID = 1L;
    protected FloatIAxis xAxis;
    protected FloatIAxis yAxis;
    protected FloatIAxis zAxis;

    FloatAbstractHistogram3D(String string) {
        super(string);
    }

    public int allEntries() {
        int n = 0;
        int n2 = this.xAxis.bins();
        while (--n2 >= -2) {
            int n3 = this.yAxis.bins();
            while (--n3 >= -2) {
                int n4 = this.zAxis.bins();
                while (--n4 >= -2) {
                    n += this.binEntries(n2, n3, n4);
                }
            }
        }
        return n;
    }

    public int dimensions() {
        return 3;
    }

    public int entries() {
        int n = 0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                for (int k = 0; k < this.zAxis.bins(); ++k) {
                    n += this.binEntries(i, j, k);
                }
            }
        }
        return n;
    }

    public int extraEntries() {
        return this.allEntries() - this.entries();
    }

    public void fill(float f, float f2, float f3) {
        this.fill(f, f2, f3, 1.0f);
    }

    protected abstract FloatIHistogram2D internalSliceXY(String var1, int var2, int var3);

    protected abstract FloatIHistogram2D internalSliceXZ(String var1, int var2, int var3);

    protected abstract FloatIHistogram2D internalSliceYZ(String var1, int var2, int var3);

    int mapX(int n) {
        int n2 = this.xAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    int mapY(int n) {
        int n2 = this.yAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    int mapZ(int n) {
        int n2 = this.zAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    public int[] minMaxBins() {
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = this.xAxis.bins();
        while (--n7 >= 0) {
            int n8 = this.yAxis.bins();
            while (--n8 >= 0) {
                int n9 = this.zAxis.bins();
                while (--n9 >= 0) {
                    float f3 = this.binHeight(n7, n8, n9);
                    if (f3 < f) {
                        f = f3;
                        n = n7;
                        n2 = n8;
                        n3 = n9;
                    }
                    if (!(f3 > f2)) continue;
                    f2 = f3;
                    n4 = n7;
                    n5 = n8;
                    n6 = n9;
                }
            }
        }
        int[] nArray = new int[]{n, n2, n3, n4, n5, n6};
        return nArray;
    }

    public FloatIHistogram2D projectionXY() {
        String string = this.title() + " (projectionXY)";
        return this.internalSliceXY(string, this.mapZ(-2), this.mapZ(-1));
    }

    public FloatIHistogram2D projectionXZ() {
        String string = this.title() + " (projectionXZ)";
        return this.internalSliceXZ(string, this.mapY(-2), this.mapY(-1));
    }

    public FloatIHistogram2D projectionYZ() {
        String string = this.title() + " (projectionYZ)";
        return this.internalSliceYZ(string, this.mapX(-2), this.mapX(-1));
    }

    public FloatIHistogram2D sliceXY(int n) {
        return this.sliceXY(n, n);
    }

    public FloatIHistogram2D sliceXY(int n, int n2) {
        int n3 = this.mapZ(n);
        int n4 = this.mapZ(n2);
        String string = this.title() + " (sliceXY [" + n + ":" + n2 + "])";
        return this.internalSliceXY(string, n3, n4);
    }

    public FloatIHistogram2D sliceXZ(int n) {
        return this.sliceXZ(n, n);
    }

    public FloatIHistogram2D sliceXZ(int n, int n2) {
        int n3 = this.mapY(n);
        int n4 = this.mapY(n2);
        String string = this.title() + " (sliceXZ [" + n + ":" + n2 + "])";
        return this.internalSliceXY(string, n3, n4);
    }

    public FloatIHistogram2D sliceYZ(int n) {
        return this.sliceYZ(n, n);
    }

    public FloatIHistogram2D sliceYZ(int n, int n2) {
        int n3 = this.mapX(n);
        int n4 = this.mapX(n2);
        String string = this.title() + " (sliceYZ [" + n + ":" + n2 + "])";
        return this.internalSliceYZ(string, n3, n4);
    }

    public float sumAllBinHeights() {
        float f = 0.0f;
        int n = this.xAxis.bins();
        while (--n >= -2) {
            int n2 = this.yAxis.bins();
            while (--n2 >= -2) {
                int n3 = this.zAxis.bins();
                while (--n3 >= -2) {
                    f += this.binHeight(n, n2, n3);
                }
            }
        }
        return f;
    }

    public float sumBinHeights() {
        float f = 0.0f;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                for (int k = 0; k < this.zAxis.bins(); ++k) {
                    f += this.binHeight(i, j, k);
                }
            }
        }
        return f;
    }

    public float sumExtraBinHeights() {
        return this.sumAllBinHeights() - this.sumBinHeights();
    }

    public FloatIAxis xAxis() {
        return this.xAxis;
    }

    public FloatIAxis yAxis() {
        return this.yAxis;
    }

    public FloatIAxis zAxis() {
        return this.zAxis;
    }
}

