/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import edu.emory.mathcs.csparsej.tfloat.Scs_chol;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_ipvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_lsolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_ltsolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_pvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_schol;

public class SparseFloatCholeskyDecomposition {
    private Scs_common.Scss S;
    private Scs_common.Scsn N;
    private FloatMatrix2D L;
    private boolean rcMatrix = false;
    private int n;

    public SparseFloatCholeskyDecomposition(FloatMatrix2D floatMatrix2D, int n) {
        Scs_common.Scs scs;
        FloatProperty.DEFAULT.checkSquare(floatMatrix2D);
        FloatProperty.DEFAULT.checkSparse(floatMatrix2D);
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("order must be equal 0 or 1");
        }
        if (floatMatrix2D instanceof SparseRCFloatMatrix2D) {
            this.rcMatrix = true;
            scs = ((SparseRCFloatMatrix2D)floatMatrix2D).getColumnCompressed().elements();
        } else {
            scs = (Scs_common.Scs)floatMatrix2D.elements();
        }
        this.n = floatMatrix2D.rows();
        this.S = Scs_schol.cs_schol((int)n, (Scs_common.Scs)scs);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_schol()");
        }
        this.N = Scs_chol.cs_chol((Scs_common.Scs)scs, (Scs_common.Scss)this.S);
        if (this.N == null) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite");
        }
    }

    public FloatMatrix2D getL() {
        if (this.L == null) {
            this.L = new SparseCCFloatMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCFloatMatrix2D)this.L).getRowCompressed();
            }
        }
        return this.L.copy();
    }

    public FloatMatrix2D getLtranspose() {
        if (this.L == null) {
            this.L = new SparseCCFloatMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCFloatMatrix2D)this.L).getRowCompressed();
            }
        }
        if (this.rcMatrix) {
            return ((SparseRCFloatMatrix2D)this.L).getTranspose();
        }
        return ((SparseCCFloatMatrix2D)this.L).getTranspose();
    }

    public Scs_common.Scss getSymbolicAnalysis() {
        Scs_common.Scss scss = new Scs_common.Scss();
        scss.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        scss.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        scss.lnz = this.S.lnz;
        scss.m2 = this.S.m2;
        scss.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        scss.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        scss.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        scss.unz = this.S.unz;
        return scss;
    }

    public void solve(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        FloatProperty.DEFAULT.checkDense(floatMatrix1D);
        float[] fArray = new float[this.n];
        float[] fArray2 = floatMatrix1D.isView() ? (float[])floatMatrix1D.copy().elements() : (float[])floatMatrix1D.elements();
        Scs_ipvec.cs_ipvec((int[])this.S.pinv, (float[])fArray2, (float[])fArray, (int)this.n);
        Scs_lsolve.cs_lsolve((Scs_common.Scs)this.N.L, (float[])fArray);
        Scs_ltsolve.cs_ltsolve((Scs_common.Scs)this.N.L, (float[])fArray);
        Scs_pvec.cs_pvec((int[])this.S.pinv, (float[])fArray, (float[])fArray2, (int)this.n);
        if (floatMatrix1D.isView()) {
            floatMatrix1D.assign(fArray2);
        }
    }
}

