/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tlong;

import cern.colt.PersistentObject;
import cern.colt.buffer.tlong.LongBuffer3DConsumer;
import cern.colt.list.tlong.LongArrayList;

public class LongBuffer3D
extends PersistentObject
implements LongBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected LongBuffer3DConsumer target;
    protected long[] xElements;
    protected long[] yElements;
    protected long[] zElements;
    protected LongArrayList xList;
    protected LongArrayList yList;
    protected LongArrayList zList;
    protected int capacity;
    protected int size;

    public LongBuffer3D(LongBuffer3DConsumer longBuffer3DConsumer, int n) {
        this.target = longBuffer3DConsumer;
        this.capacity = n;
        this.xElements = new long[n];
        this.yElements = new long[n];
        this.zElements = new long[n];
        this.xList = new LongArrayList(this.xElements);
        this.yList = new LongArrayList(this.yElements);
        this.zList = new LongArrayList(this.zElements);
        this.size = 0;
    }

    public void add(long l, long l2, long l3) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = l;
        this.yElements[this.size] = l2;
        this.zElements[this.size++] = l3;
    }

    public void addAllOf(LongArrayList longArrayList, LongArrayList longArrayList2, LongArrayList longArrayList3) {
        int n = longArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(longArrayList, longArrayList2, longArrayList3);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

