/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.map.tobject.AbstractLongObjectMap;
import cern.colt.map.tobject.OpenLongObjectHashMap;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.SelectedSparseObjectMatrix3D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix2D;

public class SparseObjectMatrix3D
extends ObjectMatrix3D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongObjectMap elements;

    public SparseObjectMatrix3D(Object[][][] objectArray) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length, objectArray.length == 0 ? 0 : (objectArray[0].length == 0 ? 0 : objectArray[0][0].length));
        this.assign(objectArray);
    }

    public SparseObjectMatrix3D(int n, int n2, int n3) {
        this(n, n2, n3, n * n2 * (n3 / 1000), 0.2, 0.5);
    }

    public SparseObjectMatrix3D(int n, int n2, int n3, int n4, double d, double d2) {
        this.setUp(n, n2, n3);
        this.elements = new OpenLongObjectHashMap(n4, d, d2);
    }

    protected SparseObjectMatrix3D(int n, int n2, int n3, AbstractLongObjectMap abstractLongObjectMap, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = abstractLongObjectMap;
        this.isNoView = false;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongObjectMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public synchronized Object getQuick(int n, int n2, int n3) {
        return this.elements.get((long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride);
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix3D objectMatrix3D) {
        if (objectMatrix3D instanceof SelectedSparseObjectMatrix3D) {
            SelectedSparseObjectMatrix3D selectedSparseObjectMatrix3D = (SelectedSparseObjectMatrix3D)objectMatrix3D;
            return this.elements == selectedSparseObjectMatrix3D.elements;
        }
        if (objectMatrix3D instanceof SparseObjectMatrix3D) {
            SparseObjectMatrix3D sparseObjectMatrix3D = (SparseObjectMatrix3D)objectMatrix3D;
            return this.elements == sparseObjectMatrix3D.elements;
        }
        return false;
    }

    public long index(int n, int n2, int n3) {
        return (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
    }

    public ObjectMatrix3D like(int n, int n2, int n3) {
        return new SparseObjectMatrix3D(n, n2, n3);
    }

    protected ObjectMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new SparseObjectMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    public synchronized void setQuick(int n, int n2, int n3, Object object) {
        long l = (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
        if (object == null) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, object);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public ObjectMatrix1D vectorize() {
        SparseObjectMatrix1D sparseObjectMatrix1D = new SparseObjectMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            sparseObjectMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return sparseObjectMatrix1D;
    }

    protected ObjectMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseObjectMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }

    public ObjectMatrix2D like2D(int n, int n2) {
        return new SparseObjectMatrix2D(n, n2);
    }
}

