/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.SparseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleQRDecomposition;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import java.util.Random;

public class TestSparseDoubleQRDecomposition {
    public static void main(String[] stringArray) {
        int n;
        int n2 = 280;
        int n3 = 180;
        int n4 = Math.max(n2, n3);
        Random random = new Random(0L);
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = new SparseRCDoubleMatrix2D(n2, n3);
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D2 = new SparseRCDoubleMatrix2D(n2, n3);
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(n4);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(n4);
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                ((DoubleMatrix2D)sparseRCDoubleMatrix2D).setQuick(n, i, 0.5 - random.nextDouble());
                ((DoubleMatrix2D)sparseRCDoubleMatrix2D2).setQuick(n, i, ((DoubleMatrix2D)sparseRCDoubleMatrix2D).getQuick(n, i));
            }
        }
        for (n = 0; n < n4; ++n) {
            ((DoubleMatrix1D)denseDoubleMatrix1D).setQuick(n, 0.5 - random.nextDouble());
            ((DoubleMatrix1D)denseDoubleMatrix1D2).setQuick(n, ((DoubleMatrix1D)denseDoubleMatrix1D).getQuick(n));
        }
        TestSparseDoubleQRDecomposition.testQR(sparseRCDoubleMatrix2D, sparseRCDoubleMatrix2D2, denseDoubleMatrix1D, denseDoubleMatrix1D2);
    }

    private static void testQR(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        double d = 1.0E-10;
        SparseDoubleQRDecomposition sparseDoubleQRDecomposition = new SparseDoubleQRDecomposition(doubleMatrix2D2, 0);
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D2.copy();
        sparseDoubleQRDecomposition.solve(doubleMatrix1D3);
        System.out.print("\n");
        System.out.print("------ SparseDoubleQRFactorization tests-------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n, n2));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int n3 = TestSparseDoubleQRDecomposition.checkSolution(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D3.viewPart(0, doubleMatrix2D.columns()).copy(), d);
        if (n3 == 0) {
            System.out.print("***************************************************\n");
            System.out.print(" ---- SparseDoubleQRFactorization tests... PASSED !\n");
            System.out.print("***************************************************\n");
        } else {
            System.out.print("***************************************************\n");
            System.out.print(" ---- SparseDoubleQRFactorization tests... FAILED !\n");
            System.out.print("***************************************************\n");
        }
    }

    private static int checkSolution(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d) {
        int n;
        DoubleProperty.DEFAULT.checkSparse(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix1D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix1D2);
        int n2 = doubleMatrix2D.rows();
        int n3 = doubleMatrix2D.columns();
        double d2 = 1.0;
        double d3 = -1.0;
        double d4 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix1D2);
        double d5 = SparseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix2D);
        double d6 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix1D);
        doubleMatrix2D.zMult(doubleMatrix1D2, doubleMatrix1D, d2, d3, false);
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix2D.zMult(doubleMatrix1D.viewPart(0, doubleMatrix2D.rows()).copy(), null, d2, d3, true);
        double d7 = DenseDoubleAlgebra.DEFAULT.normInfinity(doubleMatrix1D3);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||_oo).N.eps) = %e \n", d7 / ((d5 * d4 + d6) * (double)n3 * d)));
        if (d7 / ((d5 * d4 + d6) * (double)n3 * d) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            n = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            n = 0;
        }
        return n;
    }
}

