/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

class SelectedDenseDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseDComplexMatrix1D(double[] dArray, int[] nArray) {
        this(nArray.length, dArray, 0, 1, nArray, 0);
    }

    protected SelectedDenseDComplexMatrix1D(int n, double[] dArray, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = dArray;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    public double[] getQuick(int n) {
        int n2 = this.zero + n * this.stride;
        return new double[]{this.elements[this.offset + this.offsets[n2]], this.elements[this.offset + this.offsets[n2] + 1]};
    }

    public DoubleMatrix1D getRealPart() {
        final DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.size);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    double[] tmp;

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            this.tmp = SelectedDenseDComplexMatrix1D.this.getQuick(i);
                            denseDoubleMatrix1D.setQuick(i, this.tmp[0]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double[] dArray = this.getQuick(i);
                denseDoubleMatrix1D.setQuick(i, dArray[0]);
            }
        }
        return denseDoubleMatrix1D;
    }

    public DoubleMatrix1D getImaginaryPart() {
        final DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.size);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    double[] tmp;

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            this.tmp = SelectedDenseDComplexMatrix1D.this.getQuick(i);
                            denseDoubleMatrix1D.setQuick(i, this.tmp[1]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double[] dArray = this.getQuick(i);
                denseDoubleMatrix1D.setQuick(i, dArray[1]);
            }
        }
        return denseDoubleMatrix1D;
    }

    public double[] elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    protected boolean haveSharedCellsRaw(DComplexMatrix1D dComplexMatrix1D) {
        if (dComplexMatrix1D instanceof SelectedDenseDComplexMatrix1D) {
            SelectedDenseDComplexMatrix1D selectedDenseDComplexMatrix1D = (SelectedDenseDComplexMatrix1D)dComplexMatrix1D;
            return this.elements == selectedDenseDComplexMatrix1D.elements;
        }
        if (dComplexMatrix1D instanceof DenseDComplexMatrix1D) {
            DenseDComplexMatrix1D denseDComplexMatrix1D = (DenseDComplexMatrix1D)dComplexMatrix1D;
            return this.elements == denseDComplexMatrix1D.elements;
        }
        return false;
    }

    public long index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    public DComplexMatrix1D like(int n) {
        return new DenseDComplexMatrix1D(n);
    }

    public DComplexMatrix2D like2D(int n, int n2) {
        return new DenseDComplexMatrix2D(n, n2);
    }

    public DComplexMatrix2D reshape(int n, int n2) {
        throw new IllegalAccessError("This method is not supported.");
    }

    public DComplexMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalAccessError("This method is not supported.");
    }

    public void setQuick(int n, double[] dArray) {
        int n2 = this.zero + n * this.stride;
        this.elements[this.offset + this.offsets[n2]] = dArray[0];
        this.elements[this.offset + this.offsets[n2] + 1] = dArray[1];
    }

    public void setQuick(int n, double d, double d2) {
        int n2 = this.zero + n * this.stride;
        this.elements[this.offset + this.offsets[n2]] = d;
        this.elements[this.offset + this.offsets[n2] + 1] = d2;
    }

    protected void setUp(int n) {
        super.setUp(n, 0, 1);
        this.offset = 0;
    }

    protected DComplexMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseDComplexMatrix1D(this.elements, nArray);
    }
}

