/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultFirst;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseRCFloatMatrix2D
extends WrapperFloatMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected float[] values;
    protected boolean columnIndexesSorted;

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    public SparseRCFloatMatrix2D(float[][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length);
        this.assign(fArray);
    }

    public SparseRCFloatMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseRCFloatMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new int[n3];
        this.values = new float[n3];
        this.rowPointers = new int[n + 1];
    }

    public SparseRCFloatMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float f, boolean bl, boolean bl2) {
        int n3;
        block8: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block8;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (f == 0.0f) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new float[n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var10_12] = nArray2[n3];
            this.values[var10_12] = f;
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl2) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCFloatMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float[] fArray, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        block9: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block9;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (nArray.length != fArray.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new float[n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var11_13] = nArray2[n3];
            this.values[var11_13] = fArray[n3];
        }
        if (bl2) {
            this.removeZeroes();
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl3) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCFloatMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float[] fArray) {
        block3: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != n + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        this.rowPointers = nArray;
        this.columnIndexes = nArray2;
        this.values = fArray;
    }

    public FloatMatrix2D assign(final FloatFunction floatFunction) {
        if (floatFunction instanceof FloatMult) {
            float f = ((FloatMult)floatFunction).multiplicator;
            if (f == 1.0f) {
                return this;
            }
            if (f == 0.0f) {
                return this.assign(0.0f);
            }
            if (f != f) {
                return this.assign(f);
            }
            int n = this.cardinality();
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                this.values[n3] = this.values[n3] * f;
            }
        } else {
            this.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f) {
                    return floatFunction.apply(f);
                }
            });
        }
        return this;
    }

    public FloatMatrix2D assign(float f) {
        if (f == 0.0f) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, 0.0f);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values[i] = f;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D == this) {
            return this;
        }
        this.checkShape(floatMatrix2D);
        if (floatMatrix2D instanceof SparseRCFloatMatrix2D) {
            SparseRCFloatMatrix2D sparseRCFloatMatrix2D = (SparseRCFloatMatrix2D)floatMatrix2D;
            System.arraycopy(sparseRCFloatMatrix2D.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int n = sparseRCFloatMatrix2D.columnIndexes.length;
            if (this.columnIndexes.length < n) {
                this.columnIndexes = new int[n];
                this.values = new float[n];
            }
            System.arraycopy(sparseRCFloatMatrix2D.columnIndexes, 0, this.columnIndexes, 0, n);
            System.arraycopy(sparseRCFloatMatrix2D.values, 0, this.values, 0, n);
            this.columnIndexesSorted = sparseRCFloatMatrix2D.columnIndexesSorted;
        } else if (floatMatrix2D instanceof SparseCCFloatMatrix2D) {
            SparseCCFloatMatrix2D sparseCCFloatMatrix2D = ((SparseCCFloatMatrix2D)floatMatrix2D).getTranspose();
            this.rowPointers = sparseCCFloatMatrix2D.getColumnPointers();
            this.columnIndexes = sparseCCFloatMatrix2D.getRowIndexes();
            this.values = sparseCCFloatMatrix2D.getValues();
            this.columnIndexesSorted = true;
        } else {
            this.assign(0.0f);
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f) {
                    SparseRCFloatMatrix2D.this.setQuick(n, n2, f);
                    return f;
                }
            });
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D, FloatFloatFunction floatFloatFunction) {
        this.checkShape(floatMatrix2D);
        if (floatMatrix2D instanceof SparseRCFloatMatrix2D && floatFloatFunction == FloatFunctions.plus) {
            SparseRCFloatMatrix2D sparseRCFloatMatrix2D = (SparseRCFloatMatrix2D)floatMatrix2D;
            int[] nArray = sparseRCFloatMatrix2D.rowPointers;
            int[] nArray2 = sparseRCFloatMatrix2D.columnIndexes;
            float[] fArray = sparseRCFloatMatrix2D.values;
            int[] nArray3 = new int[this.rows + 1];
            int n = Math.max(this.columnIndexes.length, (int)Math.min(Integer.MAX_VALUE, (long)this.rowPointers[this.rows] + (long)nArray[this.rows]));
            int[] nArray4 = new int[n];
            float[] fArray2 = new float[n];
            int n2 = this.rows;
            int n3 = this.columns;
            int n4 = fArray2.length;
            if (floatFloatFunction == FloatFunctions.plus) {
                int n5;
                nArray3[0] = n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n6 = this.rowPointers[i];
                    int n7 = nArray[i];
                    int n8 = this.rowPointers[i + 1] - 1;
                    int n9 = nArray[i + 1] - 1;
                    while (n6 <= n8 || n7 <= n9) {
                        int n10;
                        int n11 = n6 <= n8 ? this.columnIndexes[n6] : n3 + 1;
                        if (n11 == (n10 = n7 <= n9 ? nArray2[n7] : n3 + 1)) {
                            fArray2[n5] = this.values[n6] + fArray[n7];
                            nArray4[n5] = n11;
                            ++n6;
                            ++n7;
                            ++n5;
                        } else if (n11 < n10) {
                            nArray4[n5] = n11;
                            fArray2[n5] = this.values[n6];
                            ++n6;
                            ++n5;
                        } else if (n11 > n10) {
                            nArray4[n5] = n10;
                            fArray2[n5] = fArray[n7];
                            ++n7;
                            ++n5;
                        }
                        if (n5 < n4) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    nArray3[i + 1] = n5;
                }
                this.rowPointers = nArray3;
                this.columnIndexes = nArray4;
                this.values = fArray2;
                return this;
            }
        }
        if (floatFloatFunction instanceof FloatPlusMultSecond) {
            final float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
            if (f == 0.0f) {
                return this;
            }
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f2) {
                    SparseRCFloatMatrix2D.this.setQuick(n, n2, SparseRCFloatMatrix2D.this.getQuick(n, n2) + f * f2);
                    return f2;
                }
            });
            return this;
        }
        if (floatFloatFunction instanceof FloatPlusMultFirst) {
            final float f = ((FloatPlusMultFirst)floatFloatFunction).multiplicator;
            if (f == 0.0f) {
                return this.assign(floatMatrix2D);
            }
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f2) {
                    SparseRCFloatMatrix2D.this.setQuick(n, n2, f * SparseRCFloatMatrix2D.this.getQuick(n, n2) + f2);
                    return f2;
                }
            });
            return this;
        }
        if (floatFloatFunction == FloatFunctions.mult) {
            int n = this.rows;
            while (--n >= 0) {
                int n12 = this.rowPointers[n];
                int n13 = this.rowPointers[n + 1];
                while (--n13 >= n12) {
                    int n14 = this.columnIndexes[n13];
                    int n15 = n13;
                    this.values[n15] = this.values[n15] * floatMatrix2D.getQuick(n, n14);
                    if (this.values[n13] != 0.0f) continue;
                    this.remove(n, n14);
                }
            }
            return this;
        }
        if (floatFloatFunction == FloatFunctions.div) {
            int n = this.rows;
            while (--n >= 0) {
                int n16 = this.rowPointers[n];
                int n17 = this.rowPointers[n + 1];
                while (--n17 >= n16) {
                    int n18 = this.columnIndexes[n17];
                    int n19 = n17;
                    this.values[n19] = this.values[n19] / floatMatrix2D.getQuick(n, n18);
                    if (this.values[n17] != 0.0f) continue;
                    this.remove(n, n18);
                }
            }
            return this;
        }
        return super.assign(floatMatrix2D, floatFloatFunction);
    }

    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    public FloatMatrix2D forEachNonZero(IntIntFloatFunction intIntFloatFunction) {
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.rowPointers[n];
            int n3 = this.rowPointers[n + 1];
            while (--n3 >= n2) {
                int n4 = this.columnIndexes[n3];
                float f = this.values[n3];
                float f2 = intIntFloatFunction.apply(n, n4, f);
                if (f2 == f) continue;
                this.values[n3] = f2;
            }
        }
        return this;
    }

    public SparseCCFloatMatrix2D getColumnCompressed() {
        SparseRCFloatMatrix2D sparseRCFloatMatrix2D = this.getTranspose();
        SparseCCFloatMatrix2D sparseCCFloatMatrix2D = new SparseCCFloatMatrix2D(this.rows, this.columns);
        sparseCCFloatMatrix2D.scs.i = sparseRCFloatMatrix2D.columnIndexes;
        sparseCCFloatMatrix2D.scs.p = sparseRCFloatMatrix2D.rowPointers;
        sparseCCFloatMatrix2D.scs.x = sparseRCFloatMatrix2D.values;
        sparseCCFloatMatrix2D.scs.nzmax = sparseRCFloatMatrix2D.values.length;
        sparseCCFloatMatrix2D.rowIndexesSorted = true;
        return sparseCCFloatMatrix2D;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseFloatMatrix2D getDense() {
        final DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntFloatFunction(){

            public float apply(int n, int n2, float f) {
                denseFloatMatrix2D.setQuick(n, n2, SparseRCFloatMatrix2D.this.getQuick(n, n2));
                return f;
            }
        });
        return denseFloatMatrix2D;
    }

    public synchronized float getQuick(int n, int n2) {
        int n3 = SparseRCFloatMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        float f = 0.0f;
        if (n3 >= 0) {
            f = this.values[n3];
        }
        return f;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public SparseRCFloatMatrix2D getTranspose() {
        int n = this.rowPointers[this.rows];
        int[] nArray = new int[this.columns];
        int[] nArray2 = new int[this.columns + 1];
        int[] nArray3 = new int[n];
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnIndexes[i];
            nArray[n2] = nArray[n2] + 1;
        }
        this.cumsum(nArray2, nArray, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            int n3 = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n3; ++j) {
                int n4 = this.columnIndexes[j];
                nArray[n4] = nArray[n4] + 1;
                nArray3[i] = i;
                fArray[i] = this.values[j];
            }
        }
        SparseRCFloatMatrix2D sparseRCFloatMatrix2D = new SparseRCFloatMatrix2D(this.columns, this.rows);
        sparseRCFloatMatrix2D.rowPointers = nArray2;
        sparseRCFloatMatrix2D.columnIndexes = nArray3;
        sparseRCFloatMatrix2D.values = fArray;
        return sparseRCFloatMatrix2D;
    }

    public float[] getValues() {
        return this.values;
    }

    public boolean hasColumnIndexesSorted() {
        return this.columnIndexesSorted;
    }

    public FloatMatrix2D like(int n, int n2) {
        return new SparseRCFloatMatrix2D(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return new SparseFloatMatrix1D(n);
    }

    public void removeDuplicates() {
        int n;
        int n2 = 0;
        int[] nArray = new int[this.columns];
        for (n = 0; n < this.columns; ++n) {
            nArray[n] = -1;
        }
        for (int i = 0; i < this.rows; ++i) {
            int n3 = n2;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                n = this.columnIndexes[j];
                if (nArray[n] >= n3) {
                    int n4 = nArray[n];
                    this.values[n4] = this.values[n4] + this.values[j];
                    continue;
                }
                nArray[n] = n2;
                this.columnIndexes[n2] = n;
                this.values[n2++] = this.values[j];
            }
            this.rowPointers[i] = n3;
        }
        this.rowPointers[this.rows] = n2;
    }

    public void removeZeroes() {
        int n = 0;
        float f = (float)Math.pow(2.0, -23.0);
        for (int i = 0; i < this.rows; ++i) {
            this.rowPointers[i] = n;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                if (!(Math.abs(this.values[j]) > f)) continue;
                this.values[n] = this.values[j];
                this.columnIndexes[n++] = this.columnIndexes[j];
            }
        }
        this.rowPointers[this.rows] = n;
    }

    public synchronized void setQuick(int n, int n2, float f) {
        int n3 = SparseRCFloatMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n3 >= 0) {
            if (f == 0.0f) {
                this.remove(n, n3);
            } else {
                this.values[n3] = f;
            }
            return;
        }
        if (f != 0.0f) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, f);
        }
    }

    public void sortColumnIndexes() {
        SparseRCFloatMatrix2D sparseRCFloatMatrix2D = this.getTranspose();
        this.rows = sparseRCFloatMatrix2D.rows;
        this.columns = sparseRCFloatMatrix2D.columns;
        this.columnIndexes = sparseRCFloatMatrix2D.columnIndexes;
        this.rowPointers = sparseRCFloatMatrix2D.rowPointers;
        this.values = sparseRCFloatMatrix2D.values;
        sparseRCFloatMatrix2D = this.getTranspose();
        this.rows = sparseRCFloatMatrix2D.rows;
        this.columns = sparseRCFloatMatrix2D.columns;
        this.columnIndexes = sparseRCFloatMatrix2D.columnIndexes;
        this.rowPointers = sparseRCFloatMatrix2D.rowPointers;
        this.values = sparseRCFloatMatrix2D.values;
        this.columnIndexesSorted = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            int n = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n; ++j) {
                stringBuilder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public FloatMatrix1D zMult(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, final float f, final float f2, boolean bl) {
        boolean bl2;
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = floatMatrix1D2 == null || !bl;
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = new DenseFloatMatrix1D(n);
        }
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D) || !(floatMatrix1D2 instanceof DenseFloatMatrix1D)) {
            return super.zMult(floatMatrix1D, floatMatrix1D2, f, f2, bl);
        }
        if ((long)n2 != floatMatrix1D.size() || (long)n > floatMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + floatMatrix1D.toStringShort() + ", " + floatMatrix1D2.toStringShort());
        }
        DenseFloatMatrix1D denseFloatMatrix1D = (DenseFloatMatrix1D)floatMatrix1D2;
        final float[] fArray = denseFloatMatrix1D.elements;
        final int n3 = denseFloatMatrix1D.stride();
        final int n4 = (int)floatMatrix1D2.index(0);
        DenseFloatMatrix1D denseFloatMatrix1D2 = (DenseFloatMatrix1D)floatMatrix1D;
        final float[] fArray2 = denseFloatMatrix1D2.elements;
        final int n5 = denseFloatMatrix1D2.stride();
        final int n6 = (int)floatMatrix1D.index(0);
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (bl) {
            if (!bl2 && (double)f2 != 1.0) {
                floatMatrix1D2.assign(FloatFunctions.mult(f2));
            }
            if (n7 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n8;
                int n9;
                n7 = 2;
                Future[] futureArray = new Future[n7];
                final float[] fArray3 = new float[n];
                int n10 = this.rows / n7;
                for (n9 = 0; n9 < n7; ++n9) {
                    n8 = n9 * n10;
                    final int n11 = n9 == n7 - 1 ? this.rows : n8 + n10;
                    final int n12 = n9;
                    futureArray[n9] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (n12 == 0) {
                                for (int i = n8; i < n11; ++i) {
                                    int n = SparseRCFloatMatrix2D.this.rowPointers[i + 1];
                                    float f2 = f * fArray2[n6 + n5 * i];
                                    for (int j = SparseRCFloatMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                        int n2 = SparseRCFloatMatrix2D.this.columnIndexes[j];
                                        int n32 = n4 + n3 * n2;
                                        fArray[n32] = fArray[n32] + SparseRCFloatMatrix2D.this.values[j] * f2;
                                    }
                                }
                            } else {
                                for (int i = n8; i < n11; ++i) {
                                    int n = SparseRCFloatMatrix2D.this.rowPointers[i + 1];
                                    float f3 = f * fArray2[n6 + n5 * i];
                                    for (int j = SparseRCFloatMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                        int n42;
                                        int n52 = n42 = SparseRCFloatMatrix2D.this.columnIndexes[j];
                                        fArray3[n52] = fArray3[n52] + SparseRCFloatMatrix2D.this.values[j] * f3;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n8 = n9 = n % 10; n8 < n; n8 += 10) {
                    int n13 = n4 + n8 * n3;
                    fArray[n13] = fArray[n13] + fArray3[n8];
                    int n14 = n4 + (n8 + 1) * n3;
                    fArray[n14] = fArray[n14] + fArray3[n8 + 1];
                    int n15 = n4 + (n8 + 2) * n3;
                    fArray[n15] = fArray[n15] + fArray3[n8 + 2];
                    int n16 = n4 + (n8 + 3) * n3;
                    fArray[n16] = fArray[n16] + fArray3[n8 + 3];
                    int n17 = n4 + (n8 + 4) * n3;
                    fArray[n17] = fArray[n17] + fArray3[n8 + 4];
                    int n18 = n4 + (n8 + 5) * n3;
                    fArray[n18] = fArray[n18] + fArray3[n8 + 5];
                    int n19 = n4 + (n8 + 6) * n3;
                    fArray[n19] = fArray[n19] + fArray3[n8 + 6];
                    int n20 = n4 + (n8 + 7) * n3;
                    fArray[n20] = fArray[n20] + fArray3[n8 + 7];
                    int n21 = n4 + (n8 + 8) * n3;
                    fArray[n21] = fArray[n21] + fArray3[n8 + 8];
                    int n22 = n4 + (n8 + 9) * n3;
                    fArray[n22] = fArray[n22] + fArray3[n8 + 9];
                }
                for (n8 = 0; n8 < n9; ++n8) {
                    int n23 = n4 + n8 * n3;
                    fArray[n23] = fArray[n23] + fArray3[n8];
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n24 = this.rowPointers[i + 1];
                    float f3 = f * fArray2[n6 + n5 * i];
                    for (int j = this.rowPointers[i]; j < n24; ++j) {
                        int n25 = this.columnIndexes[j];
                        int n26 = n4 + n3 * n25;
                        fArray[n26] = fArray[n26] + this.values[j] * f3;
                    }
                }
            }
            return floatMatrix1D2;
        }
        if (n7 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n7 = Math.min(n7, this.rows);
            Future[] futureArray = new Future[n7];
            int n27 = this.rows / n7;
            for (int i = 0; i < n7; ++i) {
                final int n28 = i * n27;
                final int n29 = i == n7 - 1 ? this.rows : n28 + n27;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n28 * n3;
                        int n2 = SparseRCFloatMatrix2D.this.rowPointers[n28];
                        if ((double)f2 == 0.0) {
                            for (int i = n28; i < n29; ++i) {
                                float f3 = 0.0f;
                                int n32 = SparseRCFloatMatrix2D.this.rowPointers[i + 1];
                                while (n2 + 10 < n32) {
                                    int n42 = n2 + 9;
                                    f3 += SparseRCFloatMatrix2D.this.values[n42] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n42--]] + SparseRCFloatMatrix2D.this.values[n42] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n42--]] + SparseRCFloatMatrix2D.this.values[n42] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n42--]] + SparseRCFloatMatrix2D.this.values[n42] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n42--]] + SparseRCFloatMatrix2D.this.values[n42] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n42--]] + SparseRCFloatMatrix2D.this.values[n42] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n42--]] + SparseRCFloatMatrix2D.this.values[n42] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n42--]] + SparseRCFloatMatrix2D.this.values[n42] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n42--]] + SparseRCFloatMatrix2D.this.values[n42] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n42--]] + SparseRCFloatMatrix2D.this.values[n42] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n42--]];
                                    n2 += 10;
                                }
                                while (n2 < n32) {
                                    f3 += SparseRCFloatMatrix2D.this.values[n2] * fArray2[SparseRCFloatMatrix2D.this.columnIndexes[n2]];
                                    ++n2;
                                }
                                fArray[n] = f * f3;
                                n += n3;
                            }
                        } else {
                            for (int i = n28; i < n29; ++i) {
                                float f4 = 0.0f;
                                int n52 = SparseRCFloatMatrix2D.this.rowPointers[i + 1];
                                while (n2 + 10 < n52) {
                                    int n62 = n2 + 9;
                                    f4 += SparseRCFloatMatrix2D.this.values[n62] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n62--]] + SparseRCFloatMatrix2D.this.values[n62] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n62--]] + SparseRCFloatMatrix2D.this.values[n62] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n62--]] + SparseRCFloatMatrix2D.this.values[n62] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n62--]] + SparseRCFloatMatrix2D.this.values[n62] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n62--]] + SparseRCFloatMatrix2D.this.values[n62] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n62--]] + SparseRCFloatMatrix2D.this.values[n62] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n62--]] + SparseRCFloatMatrix2D.this.values[n62] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n62--]] + SparseRCFloatMatrix2D.this.values[n62] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n62--]] + SparseRCFloatMatrix2D.this.values[n62] * fArray2[n6 + n5 * SparseRCFloatMatrix2D.this.columnIndexes[n62--]];
                                    n2 += 10;
                                }
                                while (n2 < n52) {
                                    f4 += SparseRCFloatMatrix2D.this.values[n2] * fArray2[SparseRCFloatMatrix2D.this.columnIndexes[n2]];
                                    ++n2;
                                }
                                fArray[n] = f * f4 + f2 * fArray[n];
                                n += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n30 = n4;
            int n31 = this.rowPointers[0];
            if ((double)f2 == 0.0) {
                for (int i = 0; i < this.rows; ++i) {
                    float f4 = 0.0f;
                    int n32 = this.rowPointers[i + 1];
                    while (n31 + 10 < n32) {
                        int n33 = n31 + 9;
                        f4 += this.values[n33] * fArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * fArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * fArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * fArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * fArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * fArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * fArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * fArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * fArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * fArray2[n6 + n5 * this.columnIndexes[n33--]];
                        n31 += 10;
                    }
                    while (n31 < n32) {
                        f4 += this.values[n31] * fArray2[this.columnIndexes[n31]];
                        ++n31;
                    }
                    fArray[n30] = f * f4;
                    n30 += n3;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    float f5 = 0.0f;
                    int n34 = this.rowPointers[i + 1];
                    while (n31 + 10 < n34) {
                        int n35 = n31 + 9;
                        f5 += this.values[n35] * fArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * fArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * fArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * fArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * fArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * fArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * fArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * fArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * fArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * fArray2[n6 + n5 * this.columnIndexes[n35--]];
                        n31 += 10;
                    }
                    while (n31 < n34) {
                        f5 += this.values[n31] * fArray2[this.columnIndexes[n31]];
                        ++n31;
                    }
                    fArray[n30] = f * f5 + f2 * fArray[n30];
                    n30 += n3;
                }
            }
        }
        return floatMatrix1D2;
    }

    public FloatMatrix2D zMult(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, float f, float f2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = floatMatrix2D.rows();
        int n4 = floatMatrix2D.columns();
        if (bl2) {
            n3 = floatMatrix2D.columns();
            n4 = floatMatrix2D.rows();
        }
        int n5 = n4;
        boolean bl4 = bl3 = floatMatrix2D2 == null;
        if (floatMatrix2D2 == null) {
            floatMatrix2D2 = floatMatrix2D instanceof SparseRCFloatMatrix2D ? new SparseRCFloatMatrix2D(n, n5, n * n5) : new DenseFloatMatrix2D(n, n5);
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? floatMatrix2D.viewDice() : floatMatrix2D).toStringShort());
        }
        if (floatMatrix2D2.rows() != n || floatMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? floatMatrix2D.viewDice() : floatMatrix2D).toStringShort() + ", " + floatMatrix2D2.toStringShort());
        }
        if (this == floatMatrix2D2 || floatMatrix2D == floatMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3 && (double)f2 != 1.0) {
            floatMatrix2D2.assign(FloatFunctions.mult(f2));
        }
        if (floatMatrix2D instanceof DenseFloatMatrix2D && floatMatrix2D2 instanceof DenseFloatMatrix2D) {
            SparseRCFloatMatrix2D sparseRCFloatMatrix2D = bl ? this.getTranspose() : this;
            DenseFloatMatrix2D denseFloatMatrix2D = bl2 ? (DenseFloatMatrix2D)floatMatrix2D.viewDice() : (DenseFloatMatrix2D)floatMatrix2D;
            DenseFloatMatrix2D denseFloatMatrix2D2 = (DenseFloatMatrix2D)floatMatrix2D2;
            int[] nArray = sparseRCFloatMatrix2D.rowPointers;
            int[] nArray2 = sparseRCFloatMatrix2D.columnIndexes;
            float[] fArray = sparseRCFloatMatrix2D.values;
            for (int i = 0; i < n; ++i) {
                int n6 = nArray[i + 1];
                for (int j = nArray[i]; j < n6; ++j) {
                    float f3 = fArray[j] * f;
                    int n7 = nArray2[j];
                    denseFloatMatrix2D2.viewRow(i).assign(denseFloatMatrix2D.viewRow(n7), FloatFunctions.plusMultSecond(f3));
                }
            }
        } else if (floatMatrix2D instanceof SparseRCFloatMatrix2D && floatMatrix2D2 instanceof SparseRCFloatMatrix2D) {
            int n8;
            SparseRCFloatMatrix2D sparseRCFloatMatrix2D = (SparseRCFloatMatrix2D)floatMatrix2D2;
            SparseRCFloatMatrix2D sparseRCFloatMatrix2D2 = bl ? this.getTranspose() : this;
            SparseRCFloatMatrix2D sparseRCFloatMatrix2D3 = bl2 ? ((SparseRCFloatMatrix2D)floatMatrix2D).getTranspose() : (SparseRCFloatMatrix2D)floatMatrix2D;
            int[] nArray = sparseRCFloatMatrix2D2.rowPointers;
            int[] nArray3 = sparseRCFloatMatrix2D2.columnIndexes;
            float[] fArray = sparseRCFloatMatrix2D2.values;
            int[] nArray4 = sparseRCFloatMatrix2D3.rowPointers;
            int[] nArray5 = sparseRCFloatMatrix2D3.columnIndexes;
            float[] fArray2 = sparseRCFloatMatrix2D3.values;
            int[] nArray6 = sparseRCFloatMatrix2D.rowPointers;
            int[] nArray7 = sparseRCFloatMatrix2D.columnIndexes;
            float[] fArray3 = sparseRCFloatMatrix2D.values;
            int n9 = fArray3.length;
            int[] nArray8 = new int[n4 + 1];
            for (n8 = 0; n8 < nArray8.length; ++n8) {
                nArray8[n8] = -1;
            }
            n8 = -1;
            for (int i = 0; i < n; ++i) {
                int n10;
                int n11 = nArray[i + 1];
                for (n10 = nArray[i]; n10 < n11; ++n10) {
                    float f4 = fArray[n10] * f;
                    int n12 = nArray3[n10];
                    int n13 = nArray4[n12 + 1];
                    for (int j = nArray4[n12]; j < n13; ++j) {
                        int n14 = nArray5[j];
                        int n15 = nArray8[n14];
                        if (n15 == -1) {
                            if (++n8 >= n9) {
                                throw new IllegalArgumentException("The max number of nonzero elements in C is too small.");
                            }
                            nArray7[n8] = n14;
                            nArray8[n14] = n8;
                            fArray3[n8] = f4 * fArray2[j];
                            continue;
                        }
                        int n16 = n15;
                        fArray3[n16] = fArray3[n16] + f4 * fArray2[j];
                    }
                }
                for (n10 = nArray6[i]; n10 < n8 + 1; ++n10) {
                    nArray8[nArray7[n10]] = -1;
                }
                nArray6[i + 1] = n8 + 1;
            }
        } else {
            if (bl2) {
                floatMatrix2D = floatMatrix2D.viewDice();
            }
            FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[n2];
            int n17 = n2;
            while (--n17 >= 0) {
                floatMatrix1DArray[n17] = floatMatrix2D.viewRow(n17);
            }
            FloatMatrix1D[] floatMatrix1DArray2 = new FloatMatrix1D[n];
            int n18 = n;
            while (--n18 >= 0) {
                floatMatrix1DArray2[n18] = floatMatrix2D2.viewRow(n18);
            }
            FloatPlusMultSecond floatPlusMultSecond = FloatPlusMultSecond.plusMult(0.0f);
            int[] nArray = this.columnIndexes;
            float[] fArray = this.values;
            int n19 = this.rows;
            while (--n19 >= 0) {
                int n20 = this.rowPointers[n19];
                int n21 = this.rowPointers[n19 + 1];
                while (--n21 >= n20) {
                    int n22 = nArray[n21];
                    floatPlusMultSecond.multiplicator = fArray[n21] * f;
                    if (!bl) {
                        floatMatrix1DArray2[n19].assign(floatMatrix1DArray[n22], floatPlusMultSecond);
                        continue;
                    }
                    floatMatrix1DArray2[n22].assign(floatMatrix1DArray[n19], floatPlusMultSecond);
                }
            }
        }
        return floatMatrix2D2;
    }

    private float cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            f += (float)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return f;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.rowPointers[this.rows];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, nArray, 0, n2);
        this.columnIndexes = nArray;
        float[] fArray = new float[n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, fArray, 0, n2);
        this.values = fArray;
    }

    protected FloatMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, float f) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        FloatArrayList floatArrayList = new FloatArrayList(this.values);
        floatArrayList.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.beforeInsert(n3, n2);
        floatArrayList.beforeInsert(n3, f);
        int n4 = this.rowPointers.length;
        while (--n4 > n) {
            int n5 = n4;
            this.rowPointers[n5] = this.rowPointers[n5] + 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = floatArrayList.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        FloatArrayList floatArrayList = new FloatArrayList(this.values);
        floatArrayList.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.remove(n2);
        floatArrayList.remove(n2);
        int n3 = this.rowPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.rowPointers[n4] = this.rowPointers[n4] - 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = floatArrayList.elements();
    }
}

