% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyResults.R
\name{asIncidenceResult}
\alias{asIncidenceResult}
\title{A tidy implementation of the summarised_result object for incidence results.}
\usage{
asIncidenceResult(result, metadata = FALSE)
}
\arguments{
\item{result}{A summarised_result object created by the IncidencePrevalence package.}

\item{metadata}{If TRUE additional metadata columns will be included in the result.}
}
\value{
A tibble with a tidy version of the summarised_result object.
}
\description{
A tidy implementation of the summarised_result object for incidence results.
}
\examples{
\donttest{
cdm <- mockIncidencePrevalence()
inc <- estimateIncidence(cdm, "target", "outcome")
tidy_inc <- asIncidenceResult(inc)
}

}
