#' @title Dose Response Curves from Incucyte Proliferation Assays
#'
#' @description
#' To open the vignette type \code{vignette("Overview")}
#'
#' The IncucyteDRC package provides a workflow for users of the Incucyte Zoom live cell imaging system
#' from Essen Biosciences who want to carry out a dose response analysis on their data.
#' For example, you may have grown cells in a 96-well plate that have been treated with a range
#' of concentrations of several different small molecule inhibitors.
#' Although the Incucyte Zoom software allows you to conveniently visualise these data,
#' exporting the data to a form that can then be readily analysed in PRISM is convoluted.
#' The IncucyteDRC package contains functions to make this process easier, as well as a graphical user interface.
#'
#' For full details, please read the accompanying paper for the package on F1000R: Chapman et al 2016
#'
#' If you want to see the package in action before deciding whether or not you want to install it,
#' there is a \href{https://youtu.be/EQzeKefmZVw}{YouTube video}.
#'
#' @docType package
#' @name IncucyteDRC-package
#' @aliases IncucyteDRC
#' @author Phil Chapman <phil.chapman@cruk.manchester.ac.uk>
#' @references See F1000R article
NULL
