#' Combustibles and energy resources for the main home in Spain from 2006 to 2015.
#'
#' Unitary value (euros) and consumed amount (thousands of units) of combustibles and other energy resources for the main home in Spain from 2006 to 2015.
#'
#' @docType data
#'
#' @usage data(ECResources)
#'
#' @source Spanish Statistical Office (INE), \url{http://www.ine.es}
#'
#' @format A data frame with columns:
#' \describe{
#'  \item{Time}{Year between 2006 and 2015.}
#'  \item{ElectricityPrice}{Unitary value of electricity (KWh).}
#'  \item{NaturalGasPrice}{Unitary value of natural gas (m3).}
#'  \item{LiquifiedGasPrice}{Unitary value of liquified gas (kilo).}
#'  \item{LiquifiedCombustiblesPrice}{Unitary value of liquified combustibles (l).}
#'  \item{SolidCombustiblesPrice}{Unitary value of Solid combustibles(l).}
#'  \item{ElectricityConsumed}{Consumed (thousands of units) of  electricity (KWh).}
#'  \item{NaturalGasConsumed}{Consumed (thousands of units) of  natural gas (m3).}
#'  \item{LiquifiedGasConsumed}{Consumed (thousands of units) of liquified gas (kilo).}
#'  \item{LiquifiedCombustiblesConsumed}{Consumed (thousands of units) of  liquified combustibles (l).}
#'  \item{SolidCombustiblesConsumed}{Consumed (thousands of units) of solid combustibles (l).}
#' }
#' @examples
#' \dontrun{
#'  ECResources
#' }
"ECResources"
