\name{init_reftable}
\alias{init_reftable}
\alias{init_grid}
\title{
Define starting points in parameter space.
}
\description{
These functions sample the space of estimated parameters, and also handle other fixed arguments that need to be passed to the function simulating the summary statistics. The current sampling strategy of these functions is crude but achieves desirable effects for present applications: it samples the space more uniformly than independent sampling of each point would, by generating fewer pairs of close points; and it is not exactly a regular grid. 

\code{init_reftable} allows constraints to be applied on parameters.
\code{init_grid} does not handle such constraints, and further generates replicates of \code{nRepl} of the parameter points sampled, which were required in the primitive workflow for good smoothing of the likelihood surface. 
}
\usage{
init_reftable(lower=c(par=0), upper=c(par=1), steps=NULL, 
          nUnique=NULL,                            
          maxmin=(nUnique * length(lower)^2)<400000L, 
          jitterFac=0.5, constr_crits=NULL, ...)
init_grid(lower=c(par=0), upper=c(par=1), steps=NULL, nUnique=NULL, 
          nRepl=min(10L,nUnique), maxmin=TRUE, jitterFac=0.5)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \bold{## Arguments recommended for up-to-date workflow}
  \item{lower}{
  A vector of lower bounds for the parameters, as well as fixed arguments to be passed to the function simulating the summary statistics. Elements must be named. Fixed parameters character strings.   
  }
  \item{upper}{
  A vector of upper bounds for the parameters, as well as fixed parameters. Elements must be named and match those of \code{lower}.  
  }
  \item{nUnique}{
  Number of distinct values of parameter vectors in output. The default for \code{init_reftable} is determined by a call to \code{\link{get_workflow_design}} with \code{npar} argument being the number of variable parameters as determined by comparison of \code{lower} and \code{upper}. The result from \code{get_workflow_design} can be modified by passing further arguments to this function through the \dots.
  
The default for \code{init_grid} is a less elaborate heuristic guess for good start from not too many points, computed as \code{floor(50^((v/3)^(1/3)))} where \code{v} is the number of variable parameters.  
  }
  \item{constr_crits}{NULL, or quoted expression specifying a constraints on parameters, beyond the ones defined by the ranges over each parameter: see \code{\link{constr_crits}} for details.
}
  \item{maxmin}{
    Boolean. If TRUE, use a greedy max-min strategy (GMM, inspired from Ravi et al. 1994) in the selection of points from a larger set of points generated by an hypercube-sampling step. If FALSE, \code{sample} is instead used for this second step. This may be useful as the default method becomes slow when thousands of points are to be sampled. 
  }
\bold{## Other, less useful arguments}
  \item{steps}{
    Number of steps of the grid, in each dimension of estimated parameters. If NULL, a default value is defined from the other arguments. If a single value is given, it is applied to all dimensions. Otherwise, this must have the same length as \code{lower} and \code{upper} and named in the same way as the variable parameters in these arguments.    
  }
  \item{nRepl}{
    Number of replicates of distinct values of parameter vectors in output.
  }
  \item{jitterFac}{
    Controls the amount of jitter of the points around regular grid nodes. The default value 0.5 means that a mode can move by up to half a grid step (independently in each dimension), so that two adjacent nodes moved toward each other can (almost) meet each other. 
  }
  \item{\dots}{
  Further arguments passed to \code{\link{get_workflow_design}} when \code{nUnique} is left NULL. Can be used notably to specify non-default \code{n_proj_stats} or \code{n_latent}.
  }
}
\value{
A data frame. Each row defines a list of arguments of vector of the function simulating the summary statistics.
}
\references{
Ravi S.S., Rosenkrantz D.J., Tayi G.K. 1994. Heuristic and special case algorithms for dispersion problems. Operations Research 42, 299-310.  
}
\note{
\code{init_grid} is an exported function from the \pkg{blackbox} package. 
}

\examples{
set.seed(123)
init_reftable(lower=c(mu=2.8,s2=0.5,sample.size=20),
              upper=c(mu=5.2,s2=4.5,sample.size=20))
# Less recommended:          
init_reftable(lower=c(mu=2.8,s2=0.5,sample.size=20),
              upper=c(mu=5.2,s2=4.5,sample.size=20),
              steps=c(mu=7,s2=9),nUnique=63)
init_grid()
}
