% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoriX-datasets.R
\docType{data}
\name{GNIPDataEUagg}
\alias{GNIPDataEUagg}
\alias{GNIPDataALLagg}
\title{Hydrogen delta values in precipitation water (aggregated per location)}
\format{
The *dataframe*s include many observations on the following
variables: \tabular{rlll}{
[, 1] \tab source_ID \tab (*factor*) \tab The unique identifier of the weather station\cr
[, 2] \tab mean_source_value \tab (*numeric*) \tab Average of the aggregate of hydrogen delta values (per thousand)\cr
[, 3] \tab var_source_value \tab (*numeric*) \tab Variance of the aggregate of hydrogen delta values (per thousand^2)\cr
[, 4] \tab n_source_value \tab (*numeric*) \tab Number of hydrogen delta values aggregated\cr
[, 5] \tab lat \tab (*numeric*) \tab Latitude coordinate (decimal degrees)\cr
[, 6] \tab long \tab (*numeric*) \tab Longitude coordinate (decimal degrees)\cr
[, 7] \tab elev \tab (*numeric*) \tab Elevation asl (m)\cr}
}
\source{
Data provided by the IAEA and processed by us.
}
\description{
These datasets contain the mean and variance of hydrogen delta value from
precipitation water sampled at weather stations between 1953 and 2015 in
Europe (`GNIPDataEUagg`) and in the entire world (`GNIPDataALLagg`). These
data have been extracted from the International Atomic Energy Agency IAEA in
Vienna (GNIP Project: Global Network of Isotopes in Precipitation) and
processed by us using the function [prepsources]. The data are aggregated per
location (across all month-year combinations). We no longer provide the full
non-aggregate GNIP dataset in the package as it is not free to reuse. You can
still download the complete GNIP dataset for free, but you will have to
proceed to a registration process with GNIP and use their downloading
interface WISER
(\url{https://nucleus.iaea.org/wiser/index.aspx}).
}
\details{
These datasets have been aggregated and can thus be directly used for fitting
isoscapes.

If you want to use your own dataset, you must format your data as these
datasets.
}
\examples{

head(GNIPDataALLagg)
dim(GNIPDataALLagg)
head(GNIPDataEUagg)
dim(GNIPDataEUagg)

}
\references{
GNIP Project IAEA Global Network of Isotopes in Precipitation: \url{https://www.iaea.org}
}
\seealso{
[GNIPDataDE] for a non-aggregated dataset.
}
\keyword{datasets}
