% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-tam.R
\name{control_tam}
\alias{control_tam}
\title{Control aspects of fitting a model in TAM}
\usage{
control_tam(
  set_min_to_0 = FALSE,
  control = list(snodes = 0, maxiter = 1000, increment.factor = 1, fac.oldxsi = 0),
  ...
)
}
\arguments{
\item{set_min_to_0}{Logical. \code{\link[TAM:tam.mml]{TAM::tam.mml()}} expects the data to be scored 0,
..., K. If \code{set_min_to_0 = TRUE}, the minimum of the data is subtracted from
each response, which will likely both satisfy TAM and do no harm to the
data.}

\item{control}{List of arguments passed to argument \code{control} of
\code{\link[TAM:tam.mml]{TAM::tam.mml()}}. See examples below.}

\item{...}{Other arguments passed to \code{\link[TAM:tam.mml]{TAM::tam.mml()}}.}
}
\value{
A list with one element for every argument of \code{control_tam()}.
}
\description{
This function should be used to generate the \code{control} argument of the
\code{\link[=fit.irtree_model]{fit()}} function.
}
\examples{
control_tam(set_min_to_0 = TRUE,
            control = list(snodes = 0,
                           maxiter = 1000,
                           increment.factor = 1,
                           fac.oldxsi = 0),
            constraint = "items")
}
