/*
 * Decompiled with CFR 0.152.
 */
package j4r.app;

import j4r.app.AbstractGenericTask;
import j4r.util.J4RTranslator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractGenericEngine {
    protected LinkedBlockingQueue<AbstractGenericTask> queue;
    protected List<String> tasksDone;
    private InternalWorker worker;
    private boolean goAhead = true;
    private final Object lock = new Object();
    protected EnsuringShutdownTask finalTask = new EnsuringShutdownTask();

    protected AbstractGenericEngine() {
        this.queue = new LinkedBlockingQueue();
        this.tasksDone = new CopyOnWriteArrayList<String>();
        this.worker = new InternalWorker(this);
        this.worker.start();
    }

    protected void decideWhatToDoInCaseOfFailure(AbstractGenericTask task) {
        String message = null;
        if (task.hasBeenCancelled()) {
            message = MessageID.CancelMessage.toString();
        } else {
            String taskName = task.getName();
            Exception failureCause = task.getFailureReason();
            String errorType = "";
            if (failureCause != null) {
                errorType = failureCause.getClass().getSimpleName();
                failureCause.printStackTrace();
            }
            message = String.valueOf(MessageID.ErrorMessage.toString()) + taskName + " : " + errorType;
        }
        System.out.println(message);
        this.queue.clear();
    }

    protected abstract void firstTasksToDo();

    public final void startApplication() {
        this.firstTasksToDo();
    }

    protected void shutdown(int shutdownCode) {
        System.out.println("Shutting down application...");
        System.exit(shutdownCode);
    }

    public void addTask(AbstractGenericTask task) {
        this.queue.add(task);
    }

    public void addTasks(List<AbstractGenericTask> tasks) {
        this.queue.addAll(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockEngine(long millisec) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.goAhead = false;
            while (!this.goAhead) {
                this.lock.wait(millisec);
            }
        }
    }

    protected void lockEngine() throws InterruptedException {
        if (Thread.currentThread() != this.worker) {
            this.lockEngine(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockEngine() {
        Object object = this.lock;
        synchronized (object) {
            this.goAhead = true;
            this.lock.notify();
        }
    }

    public void cancelRunningTask() {
        this.worker.requestCancel();
    }

    public void requestShutdown() {
        this.queue.clear();
        this.addTask(this.finalTask);
        try {
            this.lockEngine();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final class EnsuringShutdownTask
    extends AbstractGenericTask {
        private EnsuringShutdownTask() {
            this.setName("FinalTask");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doThisJob() throws Exception {
            Object object = AbstractGenericEngine.this.lock;
            synchronized (object) {
                AbstractGenericEngine.this.goAhead = true;
                AbstractGenericEngine.this.lock.notifyAll();
            }
            if (AbstractGenericEngine.this.worker.isCorrectlyTerminated()) {
                AbstractGenericEngine.this.shutdown(0);
            } else {
                AbstractGenericEngine.this.worker.getFailureReason().printStackTrace();
                AbstractGenericEngine.this.shutdown(1);
            }
        }
    }

    private static class InternalWorker
    extends Thread {
        private AbstractGenericEngine engine;
        private AbstractGenericTask currentTask;
        private Exception failureReason;

        private InternalWorker(AbstractGenericEngine engine) {
            this.setName("Engine - Internal task processor");
            this.engine = engine;
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                LinkedBlockingQueue<AbstractGenericTask> queue = this.engine.queue;
                do {
                    this.currentTask = queue.take();
                    if (this.currentTask.isVerbose()) {
                        System.out.println("Running task : " + this.currentTask.getName());
                    }
                    this.currentTask.run();
                    if (!this.currentTask.isCorrectlyTerminated() || this.currentTask.hasBeenCancelled()) {
                        this.engine.decideWhatToDoInCaseOfFailure(this.currentTask);
                        continue;
                    }
                    this.engine.tasksDone.add(this.currentTask.getName());
                } while (!this.currentTask.equals(this.engine.finalTask));
            }
            catch (InterruptedException e) {
                this.failureReason = e;
                System.out.println("The Engine has been interrupted!");
                this.engine.finalTask.run();
            }
        }

        protected void requestCancel() {
            if (this.currentTask != null) {
                this.currentTask.cancel();
            }
        }

        public boolean isCorrectlyTerminated() {
            return this.failureReason == null;
        }

        public Exception getFailureReason() {
            return this.failureReason;
        }
    }

    private static enum MessageID implements J4RTranslator.TextableEnum
    {
        ErrorMessage("An error of this type occured while running task ", "Une erreur de ce type est survenu pendant l'ex\u00e9cution de la t\u00e2che "),
        CancelMessage("The task has been canceled !", "La t\u00e2che a \u00e9t\u00e9 annul\u00e9e !");


        private MessageID(String englishText, String frenchText) {
            this.setText(englishText, frenchText);
        }

        @Override
        public void setText(String englishText, String frenchText) {
            J4RTranslator.setString(this, englishText, frenchText);
        }

        public String toString() {
            return J4RTranslator.getString(this);
        }
    }
}

