/*
 * Decompiled with CFR 0.152.
 */
package j4r.net;

import j4r.net.SocketWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class TCPSocketWrapper
implements SocketWrapper {
    private final byte[] buffer = new byte[100000];
    private final boolean isJavaObjectExpected;
    private final Socket socket;
    private InputStream basicIn;
    private OutputStream basicOut;
    private ObjectInputStream objectIn;
    private ObjectOutputStream objectOut;

    public TCPSocketWrapper(Socket socket, boolean isJavaObjectExpected) {
        this.socket = socket;
        this.isJavaObjectExpected = isJavaObjectExpected;
    }

    private Socket getSocket() {
        return this.socket;
    }

    @Override
    public Object readObject() throws Exception {
        return this.readObject(0);
    }

    @Override
    public Object readObject(int numberOfSeconds) throws Exception {
        this.socket.setSoTimeout(numberOfSeconds * 1000);
        Object result = this.isJavaObjectExpected ? this.getObjectInputStream().readObject() : this.readString();
        return result;
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (this.isJavaObjectExpected) {
            this.getObjectOutputStream().writeObject(obj);
        } else {
            this.writeString(obj.toString());
        }
    }

    private int readBytes(byte[] buffer) throws IOException {
        return this.getBasicInputStream().read(buffer);
    }

    private String readString() throws IOException {
        int nbBytes = this.readBytes(this.buffer);
        if (nbBytes == -1) {
            this.close();
            throw new IOException("Seems that the connection has been shutdown by the client...");
        }
        String incomingMessage = new String(this.buffer).substring(0, nbBytes);
        return incomingMessage;
    }

    private void writeString(String str) throws IOException {
        this.writeBytes(str.getBytes());
    }

    private void writeBytes(byte[] buffer) throws IOException {
        this.getBasicOutputStream().write(buffer);
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    private InputStream getBasicInputStream() throws IOException {
        if (this.basicIn == null) {
            this.basicIn = this.socket.getInputStream();
        }
        return this.basicIn;
    }

    private ObjectInputStream getObjectInputStream() throws IOException {
        if (this.objectIn == null) {
            this.objectIn = new ObjectInputStream(this.getBasicInputStream());
        }
        return this.objectIn;
    }

    private OutputStream getBasicOutputStream() throws IOException {
        if (this.basicOut == null) {
            this.basicOut = this.socket.getOutputStream();
        }
        return this.basicOut;
    }

    private ObjectOutputStream getObjectOutputStream() throws IOException {
        if (this.objectOut == null) {
            this.objectOut = new ObjectOutputStream(this.getBasicOutputStream());
        }
        return this.objectOut;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.getSocket().getInetAddress();
    }
}

