% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_functions.R
\name{recode_indicator_num}
\alias{recode_indicator_num}
\title{Converting "values variables" into "modalities variables"}
\usage{
recode_indicator_num(
  x,
  variable_name,
  breaks = c(0, 0.01, 0.05, 0.1, 1),
  labels = c("Good", "Uncertain", "Bad", "Severe"),
  ...
)
}
\arguments{
\item{x}{a \code{\link{QR_matrix}} or \code{\link{mQR_matrix}} object.}

\item{variable_name}{a vector of strings containing the names of the
variables to convert.}

\item{breaks}{see function \code{\link[base]{cut}}.}

\item{labels}{see function \code{\link[base]{cut}}.}

\item{...}{other parameters of the \code{\link[base]{cut}} function.}
}
\value{
The function \code{recode_indicator_num()} returns the same object,
enhanced with the chosen indicator. So if the input \code{x} is a QR_matrix,
an object of class \code{QR_matrix} is returned. If the input \code{x} is a
mQR_matrix, an object of class \code{mQR_matrix} is returned.
}
\description{
To transform variables from the values matrix into categorical variables
that can be added into the modalities matrix.
}
\seealso{
\link[=fr-recode_indicator_num]{Traduction française}

Other var QR_matrix manipulation: 
\code{\link{QR_var_manipulation}},
\code{\link{add_indicator}()}
}
\concept{var QR_matrix manipulation}
