/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRPackageManager;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.util.Platform;

public class JGRPrefs {
    public static final int prefsVersion = 258;
    public static final int DEBUG = 0;
    public static boolean isMac = false;
    public static String FontName = "Monospaced";
    public static int FontStyle = 0;
    public static int FontSize = 12;
    public static final int MINFONTSIZE = 18;
    public static Font DefaultFont;
    public static Color HighLightColor;
    public static Color CMDColor;
    public static Color RESULTColor;
    public static Color ERRORColor;
    public static Color BRACKETHighLight;
    public static MutableAttributeSet DEFAULTFONT;
    public static MutableAttributeSet SIZE;
    public static MutableAttributeSet CMD;
    public static MutableAttributeSet RESULT;
    public static MutableAttributeSet NORMAL;
    public static MutableAttributeSet NUMBER;
    public static Color NUMBERColor;
    public static MutableAttributeSet KEYWORD;
    public static Color KEYWORDColor;
    public static MutableAttributeSet OBJECT;
    public static Color OBJECTColor;
    public static MutableAttributeSet COMMENT;
    public static Color COMMENTColor;
    public static MutableAttributeSet QUOTE;
    public static Color QUOTEColor;
    public static int maxHelpTabs;
    public static boolean useHelpAgent;
    public static boolean useHelpAgentEditor;
    public static boolean useHelpAgentConsole;
    public static boolean useEmacsKeyBindings;
    public static boolean showHiddenFiles;
    public static String previousPackages;
    public static String workingDirectory;
    public static int tabWidth;

    public static void apply() {
        JGRPrefs.refresh();
        FontTracker.current.applyFont();
    }

    public static void initialize() {
        JGRPrefs.readPrefs();
        DefaultFont = new Font(FontName, FontStyle, FontSize);
        StyleConstants.setFontSize(SIZE, FontSize);
        StyleConstants.setFontSize(DEFAULTFONT, FontSize);
        StyleConstants.setFontFamily(DEFAULTFONT, FontName);
        StyleConstants.setForeground(CMD, CMDColor);
        StyleConstants.setForeground(RESULT, RESULTColor);
        StyleConstants.setForeground(NORMAL, Color.black);
        StyleConstants.setFontSize(NORMAL, FontSize);
        StyleConstants.setForeground(NUMBER, NUMBERColor);
        StyleConstants.setForeground(COMMENT, COMMENTColor);
        StyleConstants.setForeground(KEYWORD, KEYWORDColor);
        StyleConstants.setBold(KEYWORD, true);
        StyleConstants.setForeground(OBJECT, OBJECTColor);
        StyleConstants.setItalic(OBJECT, true);
        StyleConstants.setForeground(QUOTE, QUOTEColor);
    }

    public static void refresh() {
        DefaultFont = new Font(FontName, FontStyle, FontSize);
        StyleConstants.setFontSize(SIZE, FontSize);
        StyleConstants.setFontSize(DEFAULTFONT, FontSize);
        StyleConstants.setFontFamily(DEFAULTFONT, FontName);
        StyleConstants.setForeground(CMD, CMDColor);
        StyleConstants.setForeground(RESULT, RESULTColor);
        StyleConstants.setForeground(NORMAL, Color.black);
        StyleConstants.setFontSize(NORMAL, FontSize);
        StyleConstants.setForeground(NUMBER, NUMBERColor);
        StyleConstants.setForeground(COMMENT, COMMENTColor);
        StyleConstants.setForeground(KEYWORD, KEYWORDColor);
        StyleConstants.setBold(KEYWORD, true);
        StyleConstants.setForeground(OBJECT, OBJECTColor);
        StyleConstants.setItalic(OBJECT, true);
        StyleConstants.setForeground(QUOTE, QUOTEColor);
        if (JGR.R != null && JGR.STARTED) {
            JGR.R.eval("options(width=" + JGR.MAINRCONSOLE.getFontWidth() + ")");
        }
    }

    public static void readPrefs() {
        Preferences preferences;
        BufferedInputStream bufferedInputStream;
        block8: {
            bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(System.getProperty("user.home") + File.separator + ".JGRprefsrc"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            try {
                if (bufferedInputStream == null) break block8;
                preferences = Preferences.userNodeForPackage(JGR.class);
                try {
                    preferences.clear();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                preferences = null;
                Preferences.importPreferences(bufferedInputStream);
            }
            catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bufferedInputStream == null) {
            return;
        }
        preferences = Preferences.userNodeForPackage(JGR.class);
        FontName = preferences.get("FontName", FontName);
        FontSize = preferences.getInt("FontSize", FontSize);
        maxHelpTabs = preferences.getInt("MaxHelpTabs", maxHelpTabs);
        useHelpAgent = preferences.getBoolean("UseHelpAgent", true);
        useHelpAgentConsole = preferences.getBoolean("UseHelpAgentConsole", useHelpAgentConsole);
        useHelpAgentEditor = preferences.getBoolean("UseHelpAgentEditor", useHelpAgentEditor);
        useEmacsKeyBindings = preferences.getBoolean("UseEmacsKeyBindings", Platform.isMac);
        previousPackages = preferences.get("PreviousPackages", null);
        showHiddenFiles = preferences.getBoolean("ShowHiddenFiles", false);
        workingDirectory = preferences.get("WorkingDirectory", System.getProperty("user.home"));
        tabWidth = preferences.getInt("tabWidth", 4);
    }

    public static void writePrefs(boolean bl) {
        int n;
        String string;
        Preferences preferences = Preferences.userNodeForPackage(JGR.class);
        try {
            preferences.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        preferences.putInt("PrefsVersion", 258);
        preferences.put("FontName", FontName);
        preferences.putInt("FontSize", FontSize);
        preferences.putInt("MaxHelpTabs", maxHelpTabs);
        preferences.putBoolean("UseHelpAgent", useHelpAgent);
        preferences.putBoolean("UseHelpAgentConsole", useHelpAgentConsole);
        preferences.putBoolean("UseHelpAgentEditor", useHelpAgentEditor);
        preferences.putBoolean("UseEmacsKeyBindings", useEmacsKeyBindings);
        preferences.putBoolean("ShowHiddenFiles", showHiddenFiles);
        preferences.put("PreviousPackages", RController.getCurrentPackages() + (JGRPackageManager.remindPackages == null ? "" : "," + JGRPackageManager.remindPackages));
        preferences.put("WorkingDirectory", workingDirectory);
        preferences.putInt("tabWidth", tabWidth);
        if (JGRPackageManager.defaultPackages != null && JGRPackageManager.defaultPackages.length > 0) {
            string = JGRPackageManager.defaultPackages[JGRPackageManager.defaultPackages.length - 1].toString();
            for (n = JGRPackageManager.defaultPackages.length - 2; n >= 0; --n) {
                string = string + ", " + JGRPackageManager.defaultPackages[n];
            }
            preferences.put("DefaultPackages", string);
        }
        if (JGR.RLIBS != null && JGR.RLIBS.length > 1) {
            string = JGR.RLIBS[0].toString();
            for (n = 1; n < JGR.RLIBS.length - 1; ++n) {
                string = string + (isMac ? ":" : ";") + JGR.RLIBS[n];
            }
            preferences.put("InitialRLibraryPath", string);
        }
        try {
            preferences.exportNode(new FileOutputStream(System.getProperty("user.home") + File.separator + ".JGRprefsrc"));
        }
        catch (IOException iOException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void writeCurrentPackagesWhenExit() {
        JGRPrefs.readPrefs();
        JGRPrefs.writePrefs(false);
    }

    static {
        HighLightColor = Color.green;
        CMDColor = Color.red;
        RESULTColor = Color.blue;
        ERRORColor = Color.red;
        BRACKETHighLight = new Color(200, 255, 255);
        DEFAULTFONT = new SimpleAttributeSet();
        SIZE = new SimpleAttributeSet();
        CMD = new SimpleAttributeSet();
        RESULT = new SimpleAttributeSet();
        NORMAL = new SimpleAttributeSet();
        NUMBER = new SimpleAttributeSet();
        NUMBERColor = Color.red;
        KEYWORD = new SimpleAttributeSet();
        KEYWORDColor = new Color(0, 0, 140);
        OBJECT = new SimpleAttributeSet();
        OBJECTColor = new Color(50, 0, 140);
        COMMENT = new SimpleAttributeSet();
        COMMENTColor = new Color(0, 120, 0);
        QUOTE = new SimpleAttributeSet();
        QUOTEColor = Color.blue;
        maxHelpTabs = 10;
        useHelpAgent = true;
        useHelpAgentEditor = true;
        useHelpAgentConsole = true;
        useEmacsKeyBindings = false;
        showHiddenFiles = false;
        previousPackages = null;
        workingDirectory = System.getProperty("user.home");
        tabWidth = 4;
    }
}

