/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import com.apple.eawt.Application;
import java.awt.Desktop;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.rosuda.JGR.JGRConsole;
import org.rosuda.JGR.JGRPackageManager;
import org.rosuda.JGR.MonitoredEval;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.toolkit.ConsoleSync;
import org.rosuda.JGR.toolkit.JGRListener;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.PrefDialog;
import org.rosuda.JGR.toolkit.SplashScreen;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.util.Global;

public class JGR {
    public static final String VERSION = JGR.class.getPackage().getImplementationVersion();
    public static final String TITLE = "JGR";
    public static final String SUBTITLE = "Java Gui for R";
    public static final String DEVELTIME = "2003 - 2017";
    public static final String INSTITUTION = "RoSuDa, Univ. Augsburg";
    public static final String AUTHOR1 = "Markus Helbig";
    public static final String AUTHOR2 = "Simon Urbanek";
    public static final String AUTHOR3 = "Ian Fellows";
    public static final String WEBSITE = "http://www.rosuda.org";
    public static final String SPLASH = "jgrsplash.jpg";
    public static JGRConsole MAINRCONSOLE = null;
    public static Vector RHISTORY = null;
    public static String RHOME = null;
    public static ConsoleSync rSync = new ConsoleSync();
    public static Vector DATA = new Vector();
    public static Vector MODELS = new Vector();
    public static Vector OTHERS = new Vector();
    public static Vector FUNCTIONS = new Vector();
    public static Vector OBJECTS = new Vector();
    public static Vector KEYWORDS = new Vector();
    public static Vector KEYWORDS_OBJECTS = new Vector();
    public static boolean STARTED = false;
    public static SplashScreen splash;
    public static String[] arguments;
    private static REngine rEngine;
    private static JGRListener jgrlistener;
    private static String[] rargs;
    private static boolean JGRmain;
    private static String tempWD;
    private static String launcherPackages;
    private static boolean showSplash;

    public JGR() {
        SVar.int_NA = Integer.MIN_VALUE;
        Object dummy = new Object();
        JGRPackageManager.neededPackages.put("base", dummy);
        JGRPackageManager.neededPackages.put("graphics", dummy);
        JGRPackageManager.neededPackages.put("grDevices", dummy);
        JGRPackageManager.neededPackages.put("utils", dummy);
        JGRPackageManager.neededPackages.put("methods", dummy);
        JGRPackageManager.neededPackages.put("stats", dummy);
        JGRPackageManager.neededPackages.put("datasets", dummy);
        JGRPackageManager.neededPackages.put(TITLE, dummy);
        JGRPackageManager.neededPackages.put("rJava", dummy);
        JGRPackageManager.neededPackages.put("JavaGD", dummy);
        JGRPackageManager.neededPackages.put("iplots", dummy);
        JGRPrefs.initialize();
        splash = new SplashScreen();
        if (showSplash) {
            splash.start();
        }
        JGR.readHistory();
        MAINRCONSOLE = new JGRConsole();
        MAINRCONSOLE.setWorking(true);
        if (showSplash) {
            splash.toFront();
        }
        if (showSplash && System.getProperty("os.name").startsWith("Window")) {
            splash.stop();
            JGRPrefs.isWindows = true;
        }
        try {
            System.loadLibrary("jri");
        }
        catch (UnsatisfiedLinkError e) {
            String errStr = "all environment variables (PATH, LD_LIBRARY_PATH, etc.) are setup properly (see supplied script)";
            String libName = "libjri.so";
            if (System.getProperty("os.name").startsWith("Window")) {
                errStr = "you start JGR by double-clicking the JGR.exe program";
                libName = "jri.dll";
            }
            if (System.getProperty("os.name").startsWith("Mac")) {
                errStr = "you start JGR by double-clicking the JGR application";
                libName = "libjri.jnilib";
            }
            JOptionPane.showMessageDialog(null, "Cannot find Java/R Interface (JRI) library (" + libName + ").\nPlease make sure " + errStr + ".", "Cannot find JRI library", 0);
            System.err.println("Cannot find JRI native library!\n");
            e.printStackTrace();
            System.exit(1);
        }
        if (!Rengine.versionCheck()) {
            JOptionPane.showMessageDialog(null, "Java/R Interface (JRI) library doesn't match this JGR version.\nPlease update JGR and JRI to the latest version.", "Version Mismatch", 0);
            System.exit(2);
        }
        try {
            rEngine = new JRIEngine(rargs, MAINRCONSOLE);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unable to start R: " + e.getMessage(), "REngine problem", 0);
            System.err.println("Cannot start REngine " + e);
            System.exit(1);
        }
        try {
            rEngine.assign(".$JGR", new REXPString(JGRPrefs.workingDirectory));
            JGR.eval("try({setwd(`.$JGR`); rm(`.$JGR`)},silent=T)");
        }
        catch (REngineException e) {
            new ErrorMsg(e);
        }
        catch (REXPMismatchException e) {
            new ErrorMsg(e);
        }
        RController.requirePackages(TITLE);
        JGRPackageManager.defaultPackages = RController.getJgrDefaultPackages();
        if (launcherPackages != null) {
            RController.requirePackages(launcherPackages);
        }
        if (JGRPrefs.defaultPackages != null) {
            RController.requirePackages(JGRPrefs.defaultPackages);
        }
        STARTED = true;
        if (showSplash && !System.getProperty("os.name").startsWith("Win")) {
            splash.stop();
        }
        MAINRCONSOLE.execute("", false);
        MAINRCONSOLE.toFront();
        JGR.MAINRCONSOLE.input.requestFocus();
        int w = MAINRCONSOLE.getFontWidth();
        if (w > 0) {
            JGR.threadedEval("options(width=" + w + ")");
        }
        System.setOut(MAINRCONSOLE.getStdOutPrintStream());
        System.setErr(MAINRCONSOLE.getStdErrPrintStream());
        new Refresher().run();
    }

    public static REXP idleEval(String cmd) throws REngineException, REXPMismatchException {
        if (JGR.getREngine() == null) {
            throw new REngineException(null, "REngine not available");
        }
        REXP x = null;
        int lock = JGR.getREngine().tryLock();
        if (lock != 0) {
            try {
                x = JGR.getREngine().parseAndEval(cmd, null, true);
            }
            finally {
                JGR.getREngine().unlock(lock);
            }
        }
        return x;
    }

    public static REXP eval(String cmd) throws REngineException, REXPMismatchException {
        if (JGR.getREngine() == null) {
            throw new REngineException(null, "REngine not available");
        }
        REXP x = JGR.getREngine().parseAndEval(cmd, null, true);
        return x;
    }

    public static void threadedEval(String cmd) {
        final String c = cmd;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JGR.eval(c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    public static REXP timedEval(String cmd) {
        return JGR.timedEval(cmd, 15000, true);
    }

    public static REXP timedEval(String cmd, boolean ask) {
        return JGR.timedEval(cmd, 15000, ask);
    }

    public static REXP timedEval(String cmd, int interval, boolean ask) {
        return new MonitoredEval(interval, ask).run(cmd);
    }

    public static void timedAssign(String symbol, REXP value) {
        JGR.timedAssign(symbol, value, 15000, true);
    }

    public static void timedAssign(String symbol, REXP value, boolean ask) {
        JGR.timedAssign(symbol, value, 15000, ask);
    }

    public static void timedAssign(String symbol, REXP value, int interval, boolean ask) {
        new MonitoredEval(interval, ask).assign(symbol, value);
    }

    public static REngine getREngine() {
        return rEngine;
    }

    public static void setREngine(REngine e) {
        rEngine = e;
    }

    public static String exit() {
        int exit = 1;
        if (JGRPrefs.askForSavingWorkspace) {
            exit = JOptionPane.showConfirmDialog(null, "Save workspace?", "Close JGR", 1, 3);
        }
        if (exit == 0) {
            JGR.writeHistory();
            JGRPrefs.writeCurrentPackagesWhenExit();
            return "y\n";
        }
        if (exit == 1) {
            JGRPrefs.writeCurrentPackagesWhenExit();
            return "n\n";
        }
        return "c\n";
    }

    public static void addMenu(String name) {
        if (MAINRCONSOLE == null) {
            return;
        }
        EzMenuSwing.addMenu(MAINRCONSOLE, name);
    }

    public static void insertMenu(String name, int pos) {
        if (MAINRCONSOLE == null) {
            return;
        }
        JGR.insertMenu(MAINRCONSOLE, name, pos);
    }

    private static void insertMenu(JFrame f, String name, int index) {
        JMenuBar mb = f.getJMenuBar();
        JMenu m = EzMenuSwing.getMenu(f, name);
        if (m == null && index < mb.getMenuCount()) {
            JMenuBar mb2 = new JMenuBar();
            int cnt = mb.getMenuCount();
            for (int i = 0; i < cnt; ++i) {
                if (i == index) {
                    mb2.add(new JMenu(name));
                }
                mb2.add(mb.getMenu(0));
            }
            f.setJMenuBar(mb2);
        } else if (m == null && index == mb.getMenuCount()) {
            EzMenuSwing.addMenu(f, name);
        }
    }

    public static void addMenuItem(String menu, String name, String cmd, boolean silent) {
        if (MAINRCONSOLE == null) {
            return;
        }
        JGRListener listener = new JGRListener(silent);
        EzMenuSwing.addJMenuItem(MAINRCONSOLE, menu, name, cmd, listener);
    }

    public static void addMenuItem(String menu, String name, String cmd) {
        JGR.addMenuItem(menu, name, cmd, true);
    }

    public static void addMenuSeparator(String menu) {
        if (MAINRCONSOLE == null) {
            return;
        }
        EzMenuSwing.addMenuSeparator(MAINRCONSOLE, menu);
    }

    public static void insertMenuSeparator(String menu, int pos) {
        if (MAINRCONSOLE == null) {
            return;
        }
        JMenu m = EzMenuSwing.getMenu(MAINRCONSOLE, menu);
        m.insertSeparator(pos);
    }

    public static void insertMenuItem(String menu, String name, String cmd, boolean silent, int pos) {
        if (MAINRCONSOLE == null) {
            return;
        }
        JGRListener listener = new JGRListener(silent);
        JGR.insertJMenuItem(MAINRCONSOLE, menu, name, cmd, listener, pos);
    }

    private static void insertJMenuItem(JFrame f, String menu, String name, String command, ActionListener al, int index) {
        JMenu m = EzMenuSwing.getMenu(f, menu);
        JMenuItem mi = new JMenuItem(name);
        mi.addActionListener(al);
        mi.setActionCommand(command);
        m.insert(mi, index);
    }

    public static void insertMenuItem(String menu, String name, String cmd, int pos) {
        JGR.insertMenuItem(menu, name, cmd, true, pos);
    }

    public static String[] getMenuNames() {
        if (MAINRCONSOLE == null) {
            return new String[0];
        }
        JMenuBar mb = MAINRCONSOLE.getJMenuBar();
        String[] names = new String[mb.getMenuCount()];
        for (int i = 0; i < mb.getMenuCount(); ++i) {
            names[i] = mb.getMenu(i).getText();
        }
        return names;
    }

    public static String[] getMenuItemNames(String menuName) {
        if (MAINRCONSOLE == null) {
            return new String[0];
        }
        JMenu m = EzMenuSwing.getMenu(MAINRCONSOLE, menuName);
        String[] names = new String[m.getItemCount()];
        for (int i = 0; i < m.getItemCount(); ++i) {
            names[i] = m.getItem(i) != null ? m.getItem(i).getText() : "-";
        }
        return names;
    }

    public static void removeMenu(int pos) {
        if (MAINRCONSOLE == null) {
            return;
        }
        MAINRCONSOLE.getJMenuBar().remove(pos);
    }

    public static void removeMenu(String name) {
        String[] names = JGR.getMenuNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(name)) continue;
            MAINRCONSOLE.remove(i);
        }
    }

    public static void removeMenuItem(String menuName, int pos) {
        JMenu menu = EzMenuSwing.getMenu(MAINRCONSOLE, menuName);
        menu.remove(pos);
    }

    public static void removeMenuItem(String menuName, String itemName) {
        JMenu menu = EzMenuSwing.getMenu(MAINRCONSOLE, menuName);
        String[] names = JGR.getMenuItemNames(menuName);
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(itemName)) continue;
            menu.remove(i);
        }
    }

    public static void insertSubMenu(String menuName, String subMenuName, int pos, String[] labels, String[] cmds) {
        JMenu sm = new JMenu(subMenuName);
        sm.setMnemonic(83);
        for (int i = 0; i < labels.length; ++i) {
            JMenuItem mi = new JMenuItem();
            mi.setText(labels[i]);
            mi.setActionCommand(cmds[i]);
            mi.addActionListener(new JGRListener(true));
            sm.add(mi);
        }
        JMenu menu = EzMenuSwing.getMenu(MAINRCONSOLE, menuName);
        menu.insert(sm, pos);
    }

    public static void addSubMenu(String menuName, String subMenuName, String[] labels, String[] cmds) {
        JMenu sm = new JMenu(subMenuName);
        sm.setMnemonic(83);
        for (int i = 0; i < labels.length; ++i) {
            JMenuItem mi = new JMenuItem();
            mi.setText(labels[i]);
            mi.setActionCommand(cmds[i]);
            mi.addActionListener(new JGRListener(true));
            sm.add(mi);
        }
        JMenu menu = EzMenuSwing.getMenu(MAINRCONSOLE, menuName);
        menu.add(sm);
    }

    public static void setRHome(String rhome) {
        RHOME = rhome;
    }

    public static void setKeyWords(String word) {
        JGR.setKeyWords(new String[]{word});
    }

    public static void setKeyWords(String[] words) {
        KEYWORDS.clear();
        for (int i = 0; i < words.length; ++i) {
            KEYWORDS.add(words[i]);
        }
    }

    public static void setObjects(String object) {
        JGR.setObjects(new String[]{object});
    }

    public static void setObjects(String[] objects) {
        OBJECTS.clear();
        KEYWORDS_OBJECTS.clear();
        for (int i = 0; i < objects.length; ++i) {
            String object = objects[i];
            if ("tempMatrixContentJGR".equals(object) || "tempMatrixDimNamesJGR".equals(object) || "jgrtemp".equals(object)) continue;
            KEYWORDS_OBJECTS.add(object);
            OBJECTS.add(object);
        }
    }

    public static void readHistory() {
        File hist = null;
        try {
            tempWD = JGRPrefs.workingDirectory;
            hist = new File(JGRPrefs.workingDirectory + File.separator + ".JGRhistory");
            if (hist.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(hist));
                RHISTORY = new Vector();
                String cmd = null;
                while (reader.ready()) {
                    if (!(cmd = (cmd == null ? "" : cmd + "\n") + reader.readLine()).endsWith("#")) continue;
                    RHISTORY.add(cmd.substring(0, cmd.length() - 1));
                    cmd = null;
                }
                reader.close();
            }
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
    }

    public static void writeHistory() {
        File hist = null;
        try {
            hist = new File(tempWD + File.separator + ".JGRhistory");
            BufferedWriter writer = new BufferedWriter(new FileWriter(hist));
            Enumeration e = RHISTORY.elements();
            while (e.hasMoreElements()) {
                writer.write(e.nextElement().toString() + "#\n");
                writer.flush();
            }
            writer.close();
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
    }

    public static boolean isJGRmain() {
        return JGRmain;
    }

    public static void main(String[] args) throws ClassNotFoundException, UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException {
        JGRPrefs.isMac = Common.isMac();
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.graphics.EnableQ2DX", "true");
        System.setProperty("apple.awt.textantialiasing", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", TITLE);
        if (Common.isMac()) {
            Application macApplication = Application.getApplication();
            List actions = Arrays.stream(Desktop.Action.values()).map(Enum::name).collect(Collectors.toList());
            if (actions.contains("APP_ABOUT")) {
                Desktop.getDesktop().setAboutHandler(aboutEvent -> new AboutDialog());
            } else {
                macApplication.setAboutHandler(aboutEvent -> new AboutDialog());
            }
            if (actions.contains("APP_PREFERENCES")) {
                Desktop.getDesktop().setPreferencesHandler(preferencesEvent -> {
                    PrefDialog inst = PrefDialog.showPreferences(null);
                    inst.setLocationRelativeTo(null);
                    inst.setVisible(true);
                });
            } else {
                macApplication.setPreferencesHandler(preferencesEvent -> {
                    PrefDialog inst = PrefDialog.showPreferences(null);
                    inst.setLocationRelativeTo(null);
                    inst.setVisible(true);
                });
            }
            if (actions.contains("APP_QUIT_HANDLER")) {
                Desktop.getDesktop().setQuitHandler((quitEvent, quitResponse) -> MAINRCONSOLE.exit());
            } else {
                macApplication.setQuitHandler((quitEvent, quitResponse) -> MAINRCONSOLE.exit());
            }
        }
        JGRmain = true;
        arguments = args;
        if (args.length > 0) {
            Vector<String> args2 = new Vector<String>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("--debug")) {
                    Global.DEBUG = 1;
                    Rengine.DEBUG = 1;
                    System.out.println("JGR version " + VERSION);
                } else {
                    args2.add(args[i]);
                }
                if (args[i].equals("--version")) {
                    System.out.println("JGR version " + VERSION);
                    System.exit(0);
                }
                if (args[i].equals("--help") || args[i].equals("-h")) {
                    System.out.println("JGR version " + VERSION);
                    System.out.println("\nOptions:");
                    System.out.println("\n\t-h, --help\t Print short helpmessage and exit");
                    System.out.println("\t--version\t Print version end exit");
                    System.out.println("\t--debug\t Print more information about JGR's process");
                    System.out.println("\nMost other R options are supported too");
                    System.exit(0);
                }
                if (args[i].startsWith("--withPackages=")) {
                    launcherPackages = args[i].substring(15);
                }
                if (!args[i].startsWith("--noSplash")) continue;
                showSplash = false;
            }
            Object[] arguments = args2.toArray();
            if (arguments.length > 0) {
                rargs = new String[arguments.length + 1];
                for (int i = 0; i < rargs.length - 1; ++i) {
                    JGR.rargs[i] = arguments[i].toString();
                }
                JGR.rargs[JGR.rargs.length - 1] = "--save";
            }
        }
        if (Global.DEBUG > 0) {
            for (int i = 0; i < rargs.length; ++i) {
                System.out.println(rargs[i]);
            }
        }
        String nativeLF = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(nativeLF);
        }
        catch (InstantiationException arguments) {
        }
        catch (ClassNotFoundException arguments) {
        }
        catch (UnsupportedLookAndFeelException arguments) {
        }
        catch (IllegalAccessException arguments) {
            // empty catch block
        }
        try {
            new JGR();
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
    }

    public static void refreshObjects() {
        try {
            REXP x = JGR.idleEval("try(.refreshObjects(),silent=TRUE)");
            String[] r = null;
            if (x != null && (r = x.asStrings()) != null) {
                JGR.setObjects(r);
            }
        }
        catch (REngineException e) {
            new ErrorMsg(e);
        }
        catch (REXPMismatchException e) {
            new ErrorMsg(e);
        }
    }

    private void checkForMissingPkg() {
        try {
            String previous = JGRPrefs.previousPackages;
            if (previous == null) {
                return;
            }
            String current = RController.getCurrentPackages();
            if (current == null) {
                return;
            }
            Vector<String> currentPkg = new Vector<String>();
            Vector<String> previousPkg = new Vector<String>();
            StringTokenizer st = new StringTokenizer(current, ",");
            while (st.hasMoreTokens()) {
                currentPkg.add(st.nextToken().toString().replaceFirst(",", ""));
            }
            st = new StringTokenizer(previous, ",");
            while (st.hasMoreTokens()) {
                previousPkg.add(st.nextToken().toString().replaceFirst(",", ""));
            }
            for (int i = 0; i < currentPkg.size(); ++i) {
                previousPkg.remove(currentPkg.elementAt(i));
            }
            if (previousPkg.size() > 0) {
                new JGRPackageManager(previousPkg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        arguments = new String[0];
        rEngine = null;
        jgrlistener = null;
        rargs = new String[]{"--save"};
        JGRmain = false;
        launcherPackages = null;
        showSplash = true;
    }

    class Refresher
    implements Runnable {
        public Refresher() {
            JGR.this.checkForMissingPkg();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                        REXP x = JGR.idleEval("try(.refreshKeyWords(),silent=TRUE)");
                        String[] r = null;
                        if (x != null && (r = x.asStrings()) != null) {
                            JGR.setKeyWords(r);
                        }
                        x = JGR.idleEval("try(.refreshObjects(),silent=TRUE)");
                        r = null;
                        if (x != null && (r = x.asStrings()) != null) {
                            JGR.setObjects(r);
                        }
                        RController.refreshObjects();
                    }
                }
                catch (Exception e) {
                    new ErrorMsg(e);
                    continue;
                }
                break;
            }
        }
    }
}

