/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import jedit.syntax.DefaultInputHandler;
import jedit.syntax.InputHandler;
import jedit.syntax.JEditTextArea;
import jedit.syntax.TextUtilities;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.editor.CodeCompletion;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;

public class RInputHandler
extends DefaultInputHandler {
    public static final ActionListener R_INSERT_TAB = new r_insert_tab();
    public static final ActionListener R_RUN_LINES = new r_run_lines();
    public static final ActionListener R_RUN_ALL = new r_run_all();
    public static final ActionListener R_COMMENT_LINES = new r_comment_lines();
    public static final ActionListener R_PREV_LINE = new r_prev_line(false);
    public static final ActionListener R_NEXT_LINE = new r_next_line(false);
    public static final ActionListener R_CLOSE_POPUPS = new r_close_popups();
    public static final ActionListener R_INSERT_BREAK = new r_insert_break();
    public static Popup codeCompletion;
    private static Popup funHelpTip;
    private String funHelp = null;
    private JToolTip Tip;

    public void addKeyBindings() {
        this.addDefaultKeyBindings();
        this.addKeyBinding("TAB", R_INSERT_TAB);
        this.addKeyBinding("M+ENTER", R_RUN_LINES);
        this.addKeyBinding("M+7", R_COMMENT_LINES);
        this.addKeyBinding("UP", R_PREV_LINE);
        this.addKeyBinding("DOWN", R_NEXT_LINE);
        this.addKeyBinding("ESCAPE", R_CLOSE_POPUPS);
        this.addKeyBinding("ENTER", R_INSERT_BREAK);
    }

    private String getLastCommand(KeyEvent evt) {
        char c;
        int lend;
        int loffset;
        int line;
        if (funHelpTip != null) {
            funHelpTip.hide();
        }
        JEditTextArea textArea = RInputHandler.getTextArea(evt);
        String text = textArea.getText();
        int pos = textArea.getCaretPosition();
        int lastb = textArea.getText(0, pos + 1).lastIndexOf(40);
        int lasteb = textArea.getText(0, pos).lastIndexOf(41);
        if (lasteb > lastb) {
            return null;
        }
        if (lastb < 0) {
            return null;
        }
        if (pos < 0) {
            return null;
        }
        try {
            line = textArea.getLineOfOffset(pos);
            loffset = textArea.getLineStartOffset(line);
            lend = textArea.getLineEndOffset(line);
            if (lastb > lend) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (text.substring(loffset, pos).indexOf("#") >= 0) {
            return null;
        }
        int offset = lastb--;
        int end2 = lastb;
        if (text == null) {
            return null;
        }
        for (pos = lastb; offset > -1 && pos > -1 && ((c = text.charAt(pos)) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c == '_'); --offset, --pos) {
        }
        offset = offset == -1 ? 0 : offset;
        try {
            line = textArea.getLineOfOffset(textArea.getCaretPosition());
            loffset = textArea.getLineStartOffset(line);
            lend = textArea.getLineEndOffset(line);
            if (offset < loffset || end2 > lend) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (textArea.getCaretPosition() < offset) {
            return null;
        }
        return offset != (end2 = ++lastb) ? text.substring(offset, end2).trim() : null;
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        int line;
        int carPos;
        JEditTextArea textArea2;
        if (funHelpTip != null) {
            funHelpTip.hide();
            funHelpTip = null;
        }
        if (JGRPrefs.useHelpAgentEditor) {
            try {
                String pattern;
                textArea2 = RInputHandler.getTextArea(evt);
                carPos = textArea2.getCaretPosition();
                line = textArea2.getLineOfOffset(textArea2.getCaretPosition());
                if (carPos > 0 && textArea2.getText(carPos - 1, 1).trim().length() != 0 && (pattern = this.getLastCommand(evt)) != null) {
                    String fun = pattern;
                    this.funHelp = RController.getFunHelpTip(fun);
                    if (fun != null && this.funHelp != null) {
                        this.Tip = new JToolTip();
                        this.Tip.setTipText(this.funHelp);
                        this.Tip.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                if (funHelpTip != null) {
                                    funHelpTip.hide();
                                    funHelpTip = null;
                                }
                            }
                        });
                        int x = textArea2._offsetToX(line, carPos);
                        int y = textArea2.lineToY(line);
                        Point loc = new Point(x, y);
                        SwingUtilities.convertPointToScreen(loc, (Component)evt.getSource());
                        funHelpTip = PopupFactory.getSharedInstance().getPopup((Component)evt.getSource(), this.Tip, loc.x, loc.y + 20);
                        funHelpTip.show();
                    }
                }
            }
            catch (Exception textArea2) {
                // empty catch block
            }
        }
        if (codeCompletion != null && evt.getKeyCode() != 38 && evt.getKeyCode() != 40) {
            textArea2 = RInputHandler.getTextArea(evt);
            carPos = textArea2.getCaretPosition();
            line = textArea2.getCaretLine();
            String lineStr = textArea2.getLineText(line);
            int start = 0;
            int end2 = carPos;
            try {
                start = TextUtilities.findWordStart(lineStr, carPos - textArea2.getLineStartOffset(line) - 1, ".");
            }
            catch (StringIndexOutOfBoundsException y) {
                // empty catch block
            }
            try {
                end2 = TextUtilities.findWordEnd(lineStr, carPos - textArea2.getLineStartOffset(line) - 1, ".");
            }
            catch (StringIndexOutOfBoundsException y) {
                // empty catch block
            }
            String pattern = null;
            try {
                pattern = lineStr.substring(start, end2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            if (pattern == null || pattern.trim().length() == 0 || CodeCompletion.getInstance().updateList(pattern) < 1) {
                codeCompletion.hide();
                codeCompletion = null;
            }
        }
        super.keyReleased(evt);
    }

    static {
        funHelpTip = null;
        actions.put("insert-tab", R_INSERT_TAB);
        actions.put("run-lines", R_RUN_LINES);
        actions.put("run-all", R_RUN_ALL);
        actions.put("comment-lines", R_COMMENT_LINES);
        actions.put("prev-line", R_PREV_LINE);
        actions.put("next-line", R_NEXT_LINE);
        actions.put("close-popups", R_CLOSE_POPUPS);
        actions.put("insert-break", R_INSERT_BREAK);
    }

    public static class r_insert_tab
    extends InputHandler.insert_tab {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea;
            int carPos;
            if (codeCompletion != null) {
                codeCompletion.hide();
                codeCompletion = null;
            }
            if ((carPos = (textArea = InputHandler.getTextArea(evt)).getCaretPosition()) > 0 && textArea.getText(carPos - 1, 1).trim().length() != 0) {
                int line = textArea.getCaretLine();
                String lineStr = textArea.getLineText(line);
                int start = 0;
                int end2 = carPos;
                try {
                    start = TextUtilities.findWordStart(lineStr, carPos - textArea.getLineStartOffset(line) - 1, ".");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    end2 = TextUtilities.findWordEnd(lineStr, carPos - textArea.getLineStartOffset(line) - 1, ".");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                boolean isfile = false;
                String pattern = "";
                try {
                    pattern = lineStr.substring(start, end2).trim();
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (pattern.length() <= 0) {
                    super.actionPerformed(evt);
                    return;
                }
                try {
                    isfile = lineStr.substring(start - 1, start).equalsIgnoreCase("\"");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                int x = textArea._offsetToX(line, carPos);
                int y = textArea.lineToY(line);
                Point loc = new Point(x, y);
                SwingUtilities.convertPointToScreen(loc, (Component)evt.getSource());
                int posC = -1;
                posC = isfile ? CodeCompletion.getInstance().updateFileList(pattern) : CodeCompletion.getInstance().updateList(pattern);
                if (posC > 0) {
                    codeCompletion = PopupFactory.getSharedInstance().getPopup((Component)evt.getSource(), CodeCompletion.getInstance(), loc.x, loc.y + ((Component)evt.getSource()).getFont().getSize() + 10);
                    codeCompletion.show();
                }
            } else {
                super.actionPerformed(evt);
            }
        }
    }

    public static class r_run_lines
    extends InputHandler.insert_tab {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            try {
                String s = textArea.getSelectedText();
                if (s == null) {
                    s = "";
                }
                if ((s = s.trim()).length() == 0) {
                    int line = textArea.getSelectionStartLine();
                    s = textArea.getLineText(line).trim();
                    int pos = textArea.getLineStartOffset(line + 1);
                    if (pos > 0) {
                        textArea.setCaretPosition(pos);
                    }
                }
                if (s.length() > 0) {
                    JGR.MAINRCONSOLE.execute(s.trim(), true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class r_run_all
    extends InputHandler.insert_tab {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int startLine = 0;
            int endLine = textArea.getLineCount();
            for (int line = startLine; line < endLine; ++line) {
                String lineText = textArea.getLineText(line).trim();
                if (lineText.length() <= 0) continue;
                JGR.MAINRCONSOLE.execute(lineText, true);
            }
        }
    }

    public static class r_comment_lines
    extends InputHandler.insert_tab {
        public static final String COMMENT_CHAR = "#";

        @Override
        public void actionPerformed(ActionEvent evt) {
            int ss;
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int startLine = textArea.getSelectionStartLine();
            int endLine = textArea.getSelectionEndLine();
            int so = textArea.getLineStartOffset(endLine);
            if (so == (ss = textArea.getSelectionEnd())) {
                --endLine;
            }
            if (startLine < 0) {
                startLine = endLine = textArea.getCaretLine();
            }
            for (int line = startLine; line <= endLine; ++line) {
                int pos = textArea.getLineStartOffset(line);
                try {
                    if (textArea.getLineText(line).trim().startsWith(COMMENT_CHAR)) {
                        textArea.getDocument().remove(pos, textArea.getLineText(line).indexOf(COMMENT_CHAR) + 1);
                        continue;
                    }
                    textArea.getDocument().insertString(pos, COMMENT_CHAR, null);
                    continue;
                }
                catch (BadLocationException e) {
                    new ErrorMsg(e);
                }
            }
        }
    }

    public static class r_prev_line
    extends InputHandler.prev_line {
        public r_prev_line(boolean select) {
            super(select);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (codeCompletion != null) {
                CodeCompletion.getInstance().previous();
            } else if (funHelpTip != null) {
                funHelpTip.hide();
                funHelpTip = null;
            } else {
                super.actionPerformed(evt);
            }
        }
    }

    public static class r_next_line
    extends InputHandler.next_line {
        public r_next_line(boolean select) {
            super(select);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (codeCompletion != null) {
                CodeCompletion.getInstance().next();
            } else if (funHelpTip != null) {
                funHelpTip.hide();
                funHelpTip = null;
            } else {
                super.actionPerformed(evt);
            }
        }
    }

    public static class r_close_popups
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            if (codeCompletion != null) {
                codeCompletion.hide();
                codeCompletion = null;
            }
            if (funHelpTip != null) {
                funHelpTip.hide();
                funHelpTip = null;
            }
        }
    }

    public static class r_insert_break
    extends InputHandler.insert_break {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            if (codeCompletion != null) {
                String completion = CodeCompletion.getInstance().getCompletion();
                textArea.setSelectedText(completion);
                codeCompletion.hide();
                codeCompletion = null;
            } else if (funHelpTip != null) {
                funHelpTip.hide();
                funHelpTip = null;
            } else {
                super.actionPerformed(evt);
            }
        }
    }
}

