/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.util;

import java.io.File;
import java.util.StringTokenizer;
import org.rosuda.util.GlobalConfig;

public class RecentList {
    public boolean autoSave = true;
    String appName;
    String recentKey;
    int maxEntries;
    int active;
    int serial;
    String[] list;

    public RecentList(String appName, String key, int maxEntries) {
        if (maxEntries < 1) {
            maxEntries = 8;
        }
        this.maxEntries = maxEntries;
        this.recentKey = key;
        this.appName = appName != null ? appName : "default";
        this.list = new String[maxEntries];
        this.active = 0;
        this.loadFromGlobalConfig();
    }

    public void reset() {
        this.active = 0;
        int i = 0;
        while (i < this.maxEntries) {
            this.list[i++] = null;
        }
        ++this.serial;
        if (this.autoSave) {
            this.saveToGlobalConfig();
        }
    }

    public void addEntry(String e) {
        if (e == null || e.length() < 1) {
            return;
        }
        for (int i = 0; i < this.active; ++i) {
            if (!this.list[i].equals(e)) continue;
            if (i > 0) {
                String h = this.list[i];
                for (int k = i; k > 0; --k) {
                    this.list[k] = this.list[k - 1];
                }
                this.list[0] = h;
                ++this.serial;
                if (this.autoSave) {
                    this.saveToGlobalConfig();
                }
            }
            return;
        }
        if (this.active >= this.maxEntries) {
            for (int j = this.maxEntries - 1; j > 0; --j) {
                this.list[j] = this.list[j - 1];
            }
            this.list[0] = e;
        } else {
            if (this.active > 0) {
                for (int j = this.active; j > 0; --j) {
                    this.list[j] = this.list[j - 1];
                }
            }
            this.list[0] = e;
            ++this.active;
        }
        ++this.serial;
        if (this.autoSave) {
            this.saveToGlobalConfig();
        }
    }

    public int count() {
        return this.active;
    }

    public int getSerial() {
        return this.serial;
    }

    void loadFromGlobalConfig() {
        if (this.recentKey == null) {
            return;
        }
        boolean save = this.autoSave;
        this.autoSave = false;
        GlobalConfig gc = GlobalConfig.getGlobalConfig();
        String s = gc.getParS("app." + this.appName + "." + this.recentKey);
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, "\t");
            this.active = 0;
            while (this.active < this.maxEntries && st.hasMoreTokens()) {
                this.list[this.active] = st.nextToken();
                ++this.active;
            }
        }
        this.autoSave = save;
        ++this.serial;
    }

    void saveToGlobalConfig() {
        if (this.recentKey == null) {
            return;
        }
        GlobalConfig gc = GlobalConfig.getGlobalConfig();
        String t = null;
        for (int i = 0; i < this.active; ++i) {
            t = t == null ? this.list[i] : t + "\t" + this.list[i];
        }
        gc.setParS("app." + this.appName + "." + this.recentKey, t == null ? "" : t);
    }

    public String[] getAllEntries() {
        return this.list;
    }

    public String[] getShortEntries() {
        String s;
        int i;
        String[] se = new String[this.active];
        for (i = 0; i < this.active; ++i) {
            s = this.list[i];
            int l = s.lastIndexOf(File.separatorChar);
            if (l > 0) {
                s = s.substring(l + 1);
            }
            se[i] = s;
        }
        for (i = 0; i < this.active; ++i) {
            s = se[i];
            boolean hasDupes = false;
            for (int j = 0; j < this.active; ++j) {
                if (i == j || se[j].compareTo(s) != 0) continue;
                hasDupes = true;
                se[j] = this.list[j];
            }
            if (!hasDupes) continue;
            se[i] = this.list[i];
        }
        return se;
    }
}

