% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLM_Signal_2D_support.R
\name{pspline_checker}
\alias{pspline_checker}
\title{P-spline checking algorithm for the GLM.}
\usage{
pspline_checker(family, link, bdeg, pord, nseg, lambda, ridge_adj, wts)
}
\arguments{
\item{family}{the response distribution, e.g. \code{"gaussian", "binomial", "poisson", "Gamma"} distribution. Quotes are needed.}

\item{link}{the link function, one of \code{"identity"}, \code{"log"}, \code{"sqrt"},
\code{"logit"}, \code{"probit"}, \code{"cloglog"}, \code{"loglog"}, \code{"reciprocal"};}

\item{bdeg}{the degree of B-splines.}

\item{pord}{the order of the penalty.}

\item{nseg}{the number of evenly-spaced B-spline segmements.}

\item{lambda}{the positive tuning parameter for the difference penalty.}

\item{ridge_adj}{the positive tuning parameter for the ridge penalty.}

\item{wts}{the weight vector, separate from GLM weights.}
}
\value{
\item{list}{same as inputs, with warnings if required.}
}
\description{
\code{pspline_checker} checks to see if all the inputs associated
for P-spines are properly defined.
}
