/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.GUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import org.omegahat.Environment.GUI.UserArea;
import org.omegahat.Environment.Interpreter.Evaluator;

public class WorkArea
extends JPanel {
    protected Evaluator evaluator = null;
    protected UserArea user_area = null;
    protected boolean useToolbar = false;

    public WorkArea(Evaluator evaluator) {
        this.evaluator = evaluator;
        this.make();
    }

    public int addToolbarElements(JToolBar jToolBar) {
        String[] stringArray = new String[]{"Print", "History", "Graphics"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            jToolBar.add(new JButton(stringArray[n2]));
            ++n2;
        }
        return n;
    }

    public JToolBar createToolbar() {
        this.setBackground(Color.red);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(new BevelBorder(1));
        this.addToolbarElements(jToolBar);
        return jToolBar;
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 200);
    }

    public boolean make() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.red);
        if (this.useToolbar) {
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(1));
            panel.add(this.createToolbar());
            this.add("North", panel);
        }
        this.user_area = new UserArea(this.evaluator);
        this.add("Center", this.user_area);
        return true;
    }

    public Object output() {
        return this.user_area.output();
    }
}

