/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.DataStructures.Data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.omegahat.DataStructures.Data.AbstractVariable;
import org.omegahat.DataStructures.Data.BasicFrameInt;
import org.omegahat.DataStructures.Data.DataFrameInt;
import org.omegahat.DataStructures.Data.FactorVariable;
import org.omegahat.DataStructures.Data.RealVariable;
import org.omegahat.DataStructures.Data.VariableInt;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Databases.ObjectDatabase;
import org.omegahat.Environment.Tools.DataScanner.EventDataScanner;
import org.omegahat.Environment.Tools.DataScanner.ObjectReader;
import org.omegahat.Environment.Tools.DataScanner.RecordStreamListener;
import org.omegahat.Environment.Utils.OrderedTable;

public class DataFrame
extends OrderedTable
implements Serializable,
DataFrameInt,
RecordStreamListener {
    public static VariableInt UnknownVariable = new RealVariable(0);
    private int length;
    protected String[] rowNames;
    protected boolean readHeader;
    private int numHeadersSet = 0;
    protected Hashtable metaData;

    public DataFrame() {
    }

    public DataFrame(int n) {
        this(n, (Database)new ObjectDatabase());
    }

    public DataFrame(int n, Database database) {
        this.length = n;
        if (database.size() > 0) {
            String[] stringArray = database.objects();
            int n2 = 0;
            while (n2 < stringArray.length) {
                Object object = database.get(stringArray[n2]);
                if (!(object instanceof VariableInt) || ((VariableInt)object).numObservations() != (long)n) {
                    throw new IllegalArgumentException("All database objects should be Variables with length " + String.valueOf(n));
                }
                try {
                    this.add(stringArray[n2], (VariableInt)object);
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
    }

    public DataFrame(File file) throws FileNotFoundException {
        this(file, true);
    }

    public DataFrame(File file, boolean bl) throws FileNotFoundException {
        this(new FileReader(file), bl);
    }

    public DataFrame(InputStream inputStream) {
        this(inputStream, true);
    }

    public DataFrame(InputStream inputStream, boolean bl) {
        this(new InputStreamReader(inputStream), bl);
    }

    public DataFrame(Reader reader) {
        this.read(new EventDataScanner(reader), true);
    }

    public DataFrame(Reader reader, boolean bl) {
        this.read(new EventDataScanner(reader), bl);
    }

    public DataFrame(Integer n) {
        this((int)n);
    }

    public DataFrame(EventDataScanner eventDataScanner) {
        this(eventDataScanner, true);
    }

    public DataFrame(EventDataScanner eventDataScanner, boolean bl) {
        this.read(eventDataScanner, bl);
    }

    public void add(String string) {
        try {
            this.add(string, this.createDefaultVariable(string, (int)this.numObservations()));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void add(String string, VariableInt variableInt) throws Exception {
        if (variableInt.numObservations() == (long)this.length || this.length == 0) {
            this.assign(string, variableInt);
            if (this.length == 0) {
                this.length = (int)variableInt.numObservations();
            }
        } else {
            throw new Exception("Variable length should be same as " + String.valueOf(this.length));
        }
    }

    public int add(Collection collection) {
        if (this.getVariableNames() == null || this.getVariableNames().length == 0) {
            this.createVariables(collection.size());
        }
        return this.add(collection.iterator());
    }

    public int add(Iterator iterator) {
        return this.add(iterator, this.getVariableNames());
    }

    public int add(Iterator iterator, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            Object e = iterator.next();
            VariableInt variableInt = (VariableInt)this.get(stringArray[n]);
            if (variableInt == UnknownVariable) {
                variableInt = this.createVariable(e);
                variableInt.setName(this.getVariableNames()[n]);
                this.put(this.getVariableNames()[n], variableInt);
            }
            variableInt.add(e, -1);
            ++n;
        }
        return n;
    }

    public VariableInt addVariable(String string, VariableInt variableInt) {
        try {
            this.add(string, variableInt);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return variableInt;
    }

    public VariableInt createDefaultVariable(String string) {
        return this.createDefaultVariable(string, (int)this.numObservations());
    }

    public VariableInt createDefaultVariable(String string, int n) {
        RealVariable realVariable = new RealVariable(n);
        realVariable.setName(string);
        return realVariable;
    }

    public VariableInt createVariable(int n) {
        RealVariable realVariable = new RealVariable();
        realVariable.setName("Var" + n);
        return realVariable;
    }

    protected VariableInt createVariable(Object object) {
        AbstractVariable abstractVariable = null;
        if (object instanceof String) {
            abstractVariable = new FactorVariable();
        } else if (object instanceof Number) {
            abstractVariable = new RealVariable();
        }
        return abstractVariable;
    }

    protected int createVariables(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.put("Var" + (n2 + 1), this.createVariable(n2));
            ++n2;
        }
        return n;
    }

    public Object[] get(int n) {
        String[] stringArray = this.objects();
        Object[] objectArray = new Number[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            objectArray[n2] = ((VariableInt)this.get(stringArray[n2])).value(n);
            ++n2;
        }
        return objectArray;
    }

    public DataFrame get(int[] nArray) throws Exception {
        String[] stringArray = this.objects();
        DataFrame dataFrame = new DataFrame(nArray.length);
        int n = 0;
        while (n < stringArray.length) {
            dataFrame.add(stringArray[n], ((VariableInt)this.get(stringArray[n])).values(nArray));
            ++n;
        }
        return dataFrame;
    }

    public DataFrame get(int[] nArray, String[] stringArray) throws Exception {
        DataFrame dataFrame = new DataFrame(nArray.length);
        int n = 0;
        while (n < stringArray.length) {
            VariableInt variableInt = (VariableInt)this.get(stringArray[n]);
            if (variableInt != null) {
                dataFrame.add(stringArray[n], variableInt.values(nArray));
            }
            ++n;
        }
        return dataFrame;
    }

    public DataFrame get(String[] stringArray) throws Exception {
        DataFrame dataFrame = new DataFrame(this.length);
        int n = 0;
        while (n < stringArray.length) {
            VariableInt variableInt = (VariableInt)this.get(stringArray[n]);
            if (variableInt != null) {
                dataFrame.add(stringArray[n], variableInt);
            }
            ++n;
        }
        return dataFrame;
    }

    public boolean getReadHeader() {
        return this.readHeader;
    }

    public VariableInt getVariable(String string) {
        return (VariableInt)this.get(string);
    }

    public String[] getVariableNames() {
        return this.objects();
    }

    public Hashtable metaData() {
        return this.metaData;
    }

    public Hashtable metaData(Hashtable hashtable) {
        this.metaData = hashtable;
        return this.metaData;
    }

    public boolean newRecord(Object object, ObjectReader objectReader) {
        if (object instanceof Collection) {
            if (((Collection)object).size() == 0) {
                return false;
            }
            if (this.getReadHeader()) {
                boolean bl = this.setNames((Collection)object);
                if (bl) {
                    this.setReadHeader(false);
                }
                return true;
            }
            this.add((Collection)object);
        }
        ++this.length;
        return true;
    }

    public long numObservations() {
        return this.length;
    }

    public long numVariables() {
        return ((Hashtable)((Object)this)).size();
    }

    public long read(EventDataScanner eventDataScanner, boolean bl) {
        try {
            try {
                eventDataScanner.addListener((RecordStreamListener)this, true);
                this.setReadHeader(true);
                eventDataScanner.readRecords(false);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            eventDataScanner.addListener((RecordStreamListener)this);
            throw throwable;
        }
        eventDataScanner.addListener((RecordStreamListener)this);
        return this.numObservations();
    }

    public String rowName(String string, int n) {
        String[] stringArray = this.rowNames();
        if (stringArray == null) {
            stringArray = this.rowNames(new String[(int)this.numObservations()]);
        }
        String string2 = null;
        string2 = stringArray[n];
        stringArray[n] = string;
        return string2;
    }

    public String[] rowNames() {
        return this.rowNames;
    }

    public String[] rowNames(InputStream inputStream) throws IOException {
        Vector<String> vector = new Vector<String>((int)this.numObservations());
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
        try {
            String string;
            while ((string = lineNumberReader.readLine()) != null) {
                if ((string = string.trim()).equals("")) continue;
                vector.add(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.rowNames(vector);
    }

    public String[] rowNames(Vector vector) {
        int n = vector.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return this.rowNames(stringArray);
    }

    public String[] rowNames(String[] stringArray) {
        this.rowNames = stringArray;
        return this.rowNames;
    }

    public boolean setNames(Collection collection) {
        int n = ((Hashtable)((Object)this)).size();
        int n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            this.put(string, UnknownVariable);
            ++n2;
        }
        this.numHeadersSet += collection.size();
        return this.numHeadersSet >= n;
    }

    public boolean setReadHeader(boolean bl) {
        this.readHeader = bl;
        return this.readHeader;
    }

    public BasicFrameInt subsetObservations(int n, int n2) {
        throw new RuntimeException("Not implemented yet");
    }

    public BasicFrameInt subsetObservations(int[] nArray) {
        throw new RuntimeException("Not implemented yet");
    }

    public String toString() {
        return "DataFrame: # obs " + this.numObservations() + ", # variables " + ((Hashtable)((Object)this)).size();
    }
}

