% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffeek.R
\name{diffeek}
\alias{diffeek}
\title{Fast and Scalable Estimator for Using Additional Knowledge in Learning
Sparse Structure Change of High Dimensional of Sparse Changes
in High-Dimensional Gaussian Graphical Models}
\usage{
diffeek(C, D, W, g, epsilon = 1, lambda = 0.05, covType = "cov",
  thre = "soft")
}
\arguments{
\item{C}{A input matrix for the 'control' group. It can be data matrix or
covariance matrix. If C is a symmetric matrix, the matrices are assumed to
be covariance matrix.}

\item{D}{A input matrix for the 'disease' group. It can be data matrix or
covariance matrix. If D is a symmetric matrix, the matrices are assumed to
be covariance matrix.}

\item{W}{positive weight matrix of size p x p representing prior knowledge of the graphs}

\item{g}{grouping information
(a vector of size p representing node groups, eg: c(1,1,2,2,0,0)
represents node 1&2 are in group 1, 3&4 are in group 1, 5&6 are not in any group)}

\item{epsilon}{A positive number. The hyperparameter controls the sparsity level of the
groups in g of the difference matrix}

\item{lambda}{A positive number. The hyperparameter controls the sparsity level of the difference matrix}

\item{covType}{A parameter to decide which Graphical model we choose to
estimate from the input data.

If covType = "cov", it means that we estimate multiple sparse Gaussian
Graphical models. This option assumes that we calculate (when input X
represents data directly) or use (when X elements are symmetric representing
covariance matrices) the sample covariance matrices as input to the simule
algorithm.

If covType = "kendall", it means that we estimate multiple nonparanormal
Graphical models. This option assumes that we calculate (when input X
represents data directly) or use (when X elements are symmetric representing
correlation matrices) the kendall's tau correlation matrices as input to the
simule algorithm.}

\item{thre}{A parameter to decide which threshold function to use for
\eqn{T_v}. If thre = "soft", it means that we choose soft-threshold function
as \eqn{T_v}. If thre = "hard", it means that we choose hard-threshold
function as \eqn{T_v}.}
}
\value{
\item{diffNet}{A matrix of the estimated sparse changes between two
Gaussian Graphical Models}
}
\description{
The DIFFEEK algorithm
}
\examples{
library(JointNets)
data(exampleData)
result = diffeek(exampleData[[1]], exampleData[[2]],
W = matrix(1,20,20), g = rep(0,20),epsilon = 0.2,
lambda = 0.4,covType = "cov")
plot(result)
}
\author{
Beilun Wang
}
