% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffee.R
\name{diffee}
\alias{diffee}
\title{Fast and Scalable Learning of Sparse Changes in High-Dimensional Gaussian
Graphical Model}
\usage{
diffee(C, D, lambda = 0.05, covType = "cov", intertwined = FALSE,
  thre = "soft")
}
\arguments{
\item{C}{A input matrix for the 'control' group. It can be data matrix or
covariance matrix. If C is a symmetric matrix, the matrices are assumed to
be covariance matrix.}

\item{D}{A input matrix for the 'disease' group. It can be data matrix or
covariance matrix. If D is a symmetric matrix, the matrices are assumed to
be covariance matrix.}

\item{lambda}{A positive number. The hyperparameter controls the sparsity
level of the matrices. The \eqn{\lambda_n} in the following section:
Details.}

\item{covType}{A parameter to decide which Graphical model we choose to
estimate from the input data.

If covType = "cov", it means that we estimate multiple sparse Gaussian
Graphical models. This option assumes that we calculate (when input X
represents data directly) or use (when X elements are symmetric representing
covariance matrices) the sample covariance matrices as input to the simule
algorithm.

If covType = "kendall", it means that we estimate multiple nonparanormal
Graphical models. This option assumes that we calculate (when input X
represents data directly) or use (when X elements are symmetric representing
correlation matrices) the kendall's tau correlation matrices as input to the
simule algorithm.}

\item{intertwined}{indicate whether to use intertwined covariance matrix}

\item{thre}{A parameter to decide which threshold function to use for
\eqn{T_v}. If thre = "soft", it means that we choose soft-threshold function
as \eqn{T_v}. If thre = "hard", it means that we choose hard-threshold
function as \eqn{T_v}.}
}
\value{
\item{$graphs}{A matrix of the estimated sparse changes between two
Gaussian Graphical Models} \item{$share}{null}
}
\description{
Estimate DIFFerential networks via an Elementary Estimator under a
high-dimensional situation. Please run demo(diffee) to learn the basics.
For further details, please read the
original paper: Beilun Wang, Arshdeep Sekhon, Yanjun Qi (2018)
\url{https://arxiv.org/abs/1710.11223}.
}
\details{
The DIFFEE algorithm is a fast and scalable Learning algorithm of Sparse
Changes in High-Dimensional Gaussian Graphical Model Structure. It solves
the following equation: \deqn{ \min\limits_{\Delta}||\Delta||_1 } Subject to
: \deqn{ ([T_v(\hat{\Sigma}_{d})]^{-1} -
[T_v(\hat{\Sigma}_{c})]^{-1})||_{\infty} \le \lambda_n } Please also see the
equation (2.11) in our paper. The \eqn{\lambda_n} is the hyperparameter
controlling the sparsity level of the matrix and it is the \code{lambda} in
our function. For further details, please see our paper: Beilun Wang,
Arshdeep Sekhon, Yanjun Qi (2018) \url{https://arxiv.org/abs/1710.11223}.

if labels are provided in the datalist as column names, result will contain labels (to be plotted)
}
\examples{
library(JointNets)
data(exampleData)
result = diffee(exampleData[[1]], exampleData[[2]], 0.45)
plot(result)
}
\references{
Beilun Wang, Arshdeep Sekhon, Yanjun Qi (2018). Fast and
Scalable Learning of Sparse Changes in High-Dimensional Gaussian Graphical
Model Structure. \url{https://arxiv.org/abs/1710.11223}
}
\author{
Beilun Wang
}
