% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdiffnet.R
\name{kdiffnet}
\alias{kdiffnet}
\title{Fast and Scalable Estimator for Using Additional Knowledge in Learning
Sparse Structure Change of High Dimensional of Sparse Changes
in High-Dimensional Gaussian Graphical Models}
\usage{
kdiffnet(C, D, W, g = rep(1, 100), epsilon = 1, lambda = 0.05,
  knowledgeType = "EV", gamma = 4, covType = "cov",
  intertwined = FALSE, thre = "soft", rho = 0.05, iterMax = 20)
}
\arguments{
\item{C}{A input matrix for the 'control' group. It can be data matrix or
covariance matrix. If C is a symmetric matrix, the matrices are assumed to
be covariance matrix.}

\item{D}{A input matrix for the 'disease' group. It can be data matrix or
covariance matrix. If D is a symmetric matrix, the matrices are assumed to
be covariance matrix.}

\item{W}{known edge level additional knowledge. It is a square matrix of dimension p X p where p is the input dimension.}

\item{g}{known node level additional knowledge. It is a vector of dimension 1 X p where p is the input dimension, each entry indicating membership of node to a group, 0 for a node belonging to no group. For example, in a dataset with dimension=3,g=c(0,1,1) indicates node 1 belongs to no group, and node 2 and node 3 belong to group index 1.}

\item{epsilon}{A positive number. The hyperparameter controls the sparsity level of the
groups in g of the difference matrix}

\item{lambda}{A positive number. The hyperparameter controls the sparsity level of the difference matrix}

\item{knowledgeType}{"EV": if use overlapping node and edge level additional knowledge,"E": if only edge level additional knowledge or "V": only group level knowledge}

\item{gamma}{: A positive number. This hyperparameter is used in calculating each proximity during optimization}

\item{covType}{A parameter to decide which Graphical model we choose to
estimate from the input data.

If covType = "cov", it means that we estimate multiple sparse Gaussian
Graphical models. This option assumes that we calculate (when input X
represents data directly) or use (when X elements are symmetric representing
covariance matrices) the sample covariance matrices as input to the simule
algorithm.

If covType = "kendall", it means that we estimate multiple nonparanormal
Graphical models. This option assumes that we calculate (when input X
represents data directly) or use (when X elements are symmetric representing
correlation matrices) the kendall's tau correlation matrices as input to the
simule algorithm.}

\item{intertwined}{indicate whether to use intertwined covariance matrix}

\item{thre}{A parameter to decide which threshold function to use for
\eqn{T_v}. If thre = "soft", it means that we choose soft-threshold function
as \eqn{T_v}. If thre = "hard", it means that we choose hard-threshold
function as \eqn{T_v}.}

\item{rho}{A positive number. This hyperparameter controls the learning rate of the proximal gradient method.}

\item{iterMax}{An integer. The max number of iterations in the optimization of the proximal algorithm}
}
\value{
\item{$graphs}{A matrix of the estimated sparse changes between two
Gaussian Graphical Models} \item{$share}{null}
}
\description{
The kdiffnet algorithm
}
\examples{
library(JointNets)
data(exampleData)
result = kdiffnet(exampleData[[1]], exampleData[[2]],
W = matrix(1,20,20), g = rep(0,20),epsilon = 0.2,
lambda = 0.4,covType = "cov")
plot(result)
}
\author{
Arshdeep Sekhon
}
