% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{juliaExpr}
\alias{juliaExpr}
\title{Mark a string as Julia expression}
\usage{
juliaExpr(expr)
}
\arguments{
\item{expr}{a character vector which should contain one string}
}
\description{
A given R character vector is marked as a Julia expression.
It will be executed and evaluated when passed to Julia.
This allows to pass a Julia object that is defined by complex Julia syntax
as an argument without needing the round-trip to R via \code{\link{juliaEval}}
or \code{\link{juliaLet}}.
}
\examples{
if (juliaSetupOk()) {

   # Create complicated objects like version strings in Julia, and compare them
   v1 <- juliaExpr('v"1.0.1"')
   v2 <- juliaExpr('v"1.2.0"')
   juliaCall("<", v1, v2)

}

\dontshow{
JuliaConnectoR:::stopJulia()
}
}
