% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/coef.KFS.R
\name{coef.KFS}
\alias{coef.KFS}
\title{Extract Estimated States of State Space Model}
\usage{
\method{coef}{KFS}(object, start = NULL, end = NULL, filtered = FALSE,
  states = "all", ...)
}
\arguments{
\item{object}{An object of class \code{KFS}.}

\item{start}{The start time of the period of interest. Defaults to first time
point of the object.}

\item{end}{The end time of the period of interest. Defaults to the last time
point of the object.}

\item{filtered}{Logical, return filtered instead of smoothed estimates of
state vector. Default is \code{FALSE}.}

\item{states}{Which states to extract? Either a numeric vector containing
the indices of the corresponding states, or a character vector defining the
types of the corresponding states. Possible choices are
 \code{"all"},  \code{"level"}, \code{"slope"},
 \code{"trend"},  \code{"regression"}, \code{"arima"}, \code{"custom"},
 \code{"cycle"} or \code{"seasonal"}, where \code{"trend"} extracts states relating to trend.
  These can be combined. Default is \code{"all"}.}

\item{\dots}{Ignored.}
}
\value{
Multivariate time series containing estimates states.
}
\description{
Extracts the estimated states from output of \code{KFS}. For non-Gaussian
models without simulation, these are the estimates of conditional modes of
states. For Gaussian models and non-Gaussian models with importance sampling,
these are the estimates of conditional means of states.
}

