% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.dim.R
\name{reduce.dim}
\alias{reduce.dim}
\title{Reduce Dimensionality}
\usage{
reduce.dim(fit, X, bound)
}
\arguments{
\item{fit}{The fitted cross validation object generated by glmnet::cv.glmnet.}

\item{X}{An input design matrix whose column number is the dimensionality to be reduced.}

\item{bound}{The targeted number of dimensionality after reducing.}
}
\value{
A list of (1) index.X, indices of selected columns in the design matrix;
                  (2) sub.X, indices of selected columns in the design matrix.
}
\description{
Reduce the dimensionality (i.e., the column number) of a design matrix to a desired level using Lasso.
}
\examples{
set.seed(10)
X <- matrix(rnorm(100), nrow = 10)
Y <- matrix(rnorm(10), nrow = 10)
set.seed(11)
cvob1 <- glmnet::cv.glmnet(X, Y)
tmp <- reduce.dim(fit = cvob1, X = X, bound = 3)
}
