% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.R
\name{derivatives}
\alias{derivatives}
\title{Computing kernel function derivatives}
\usage{
derivatives(object)
}
\arguments{
\item{object}{an object of class "kspm", usually, a result of a call to \code{kspm}.}
}
\value{
an object of class 'derivatives'
\item{derivmat}{a list of \eqn{n \times d}{n x d} matrix (one for each kernel) where \eqn{n}{n} is the number of subjects and \eqn{d}{d} the number of variables included in the kernel}
\item{rawmat}{a \eqn{n \times q}{n x q} matrix with all variables included in the kernel part of the model \eqn{q}{q} the number of variables included in the whole kernel part}
\item{scalemat}{scaled version of rawmat}
\item{modelmat}{matrix of correspondance between variable and kernels}
}
\description{
\code{derivatives} is a function for "kspm" object computing pointwise partial derivatives of \eqn{h(Z)} accroding to each \eqn{Z} variable.
}
\details{
derivatives are not computed for interactions. If a variable is included in several kernels, the user may obtain the corresponding pointwise derivatives by summing the pointwise derivatives associated with each kernel.
}
\references{
Kim, Choongrak, Byeong U. Park, and Woochul Kim. "Influence diagnostics in semiparametric regression models." Statistics and probability letters 60.1 (2002): 49:58.
}
\seealso{
\link{plot.derivatives}
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
