% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dheaping}
\alias{dheaping}
\title{Kernel density estimation for heaped data}
\usage{
dheaping(xheaped, rounds, burnin = 5, samples = 10, setBias = FALSE,
  weights = NULL, bw = "nrd0", boundary = FALSE, unequal = FALSE,
  random = FALSE, adjust = 1, recall = F, recallParams = c(1/3, 1/3))
}
\arguments{
\item{xheaped}{heaped values from which to estimate density of x}

\item{rounds}{rounding values, numeric vector of length >=1}

\item{burnin}{burn-in sample size}

\item{samples}{sampling iteration size}

\item{setBias}{if TRUE a rounding Bias parameter is estimated. For values above 0.5, the respondents
are more prone to round down, while for values < 0.5 they are more likely to round up}

\item{weights}{optional numeric vector of sampling weights}

\item{bw}{bandwidth selector method, defaults to "nrd0" see \code{density} for more options}

\item{boundary}{TRUE for positive only data (no positive density for negative values)}

\item{unequal}{if TRUE a probit model is fitted for the rounding probabilities with log(true value) as regressor}

\item{random}{if TRUE a random effect probit model is fitted for rounding probabilities}

\item{adjust}{as in \code{density}, the user can multiply the bandwidth by a certain factor such that bw=adjust*bw}

\item{recall}{if TRUE a recall error is introduced to the heaping model}

\item{recallParams}{recall error model parameters expression(nu) and expression(eta). Default is c(1/3, 1/3)}
}
\value{
The function returns a list object with the following objects (besides all input objects):
\item{\code{meanPostDensity}}{Vector of Mean Posterior Density}
\item{\code{gridx}}{Vector Grid on which density is evaluated}
\item{\code{resultDensity}}{Matrix with Estimated Density for each iteration}
\item{\code{resultRR}}{Matrix with rounding probability threshold values for each iteration (on probit scale)}
\item{\code{resultBias}}{Vector with estimated Bias parameter for each iteration}
\item{\code{resultBeta}}{Vector with estimated Beta parameter for each iteration}
\item{\code{resultX}}{Matrix of true latent values X estimates}
}
\description{
Kernel density estimation for heaped data
}
\examples{
#Simple Rounding   ----------------------------------------------------------
xtrue=rnorm(3000)
xrounded=round(xtrue)
est <- dheaping(xrounded,rounds=1,burnin=20,samples=50)
plot(est,trueX=xtrue)

#####################
#####Heaping
#####################
#Real Data Example  ----------------------------------------------------------
# Student learning hours per week
data(students)
xheaped <- as.numeric(na.omit(students$StudyHrs))
\dontrun{est <- dheaping(xheaped,rounds=c(1,2,5,10), boundary=TRUE, unequal=TRUE,burnin=20,samples=50)
plot(est)
summary(est)}

#Simulate Data   ----------------------------------------------------------
Sim1 <- createSim.Kernelheaping(n=500, distribution="norm",rounds=c(1,10,100),
thresholds=c(-0.5244005, 0.5244005), sd=100)
\dontrun{est <- dheaping(Sim1$xheaped,rounds=Sim1$rounds)
plot(est,trueX=Sim1$x)}

#Biased rounding
Sim2 <- createSim.Kernelheaping(n=500, distribution="gamma",rounds=c(1,2,5,10),
                     thresholds=c(-1.2815516, -0.6744898, 0.3853205),downbias=0.2,
                     shape=4,scale=8,offset=45)
\dontrun{est <- dheaping(Sim2$xheaped, rounds=Sim2$rounds, setBias=T, bw="SJ")
plot(est, trueX=Sim2$x)
summary(est)
tracePlots(est)}

Sim3 <- createSim.Kernelheaping(n=500, distribution="gamma",rounds=c(1,2,5,10),
thresholds=c(1.84, 2.64, 3.05), downbias=0.75, Beta=-0.5, shape=4, scale=8)
\dontrun{est <- dheaping(Sim3$xheaped,rounds=Sim3$rounds,boundary=TRUE,unequal=TRUE,setBias=T)
plot(est,trueX=Sim3$x)}
}

