\name{bwplot2}
\alias{bwplot2}
\title{Custom Lattice Boxplot}
\usage{
  bwplot2(form, data = NULL, xlab = NULL, ylab = NULL,
    main = NULL, n = 10, ...)
}
\arguments{
  \item{form}{a formula object as expected by
  \code{lattice}'s \code{xyplot}.}

  \item{data}{see \code{\link{xyplot}}.}

  \item{xlab}{see \code{\link{xyplot}}.}

  \item{ylab}{see \code{\link{xyplot}}.}

  \item{main}{see \code{\link{xyplot}}.}

  \item{n}{number of points necessary for a boxplot to be
  drawn.}

  \item{...}{additional arguments passed to \code{xyplot}
  call.}
}
\description{
  This generates a custom lattice boxplot; we super-impose
  actual plot points for groups with a small number of
  points, and also restrict plotting of the boxplot for
  these as well (since they are really rather
  mis-representative of the distribution when there are so
  few points.) The downside is that functionality is not
  implemented for multi-panel plots.
}
\details{
  Axis labels are inferred from the \code{form} object
  passed in when possible.
}
\examples{
set.seed(123)
dat <- data.frame( y=rnorm(100), x=factor( rbinom(100,size=2,p=0.8) ) )
bwplot2( x ~ y , dat)
}

