/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import kr.ac.kaist.swrc.jhannanum.share.TagSet;

public class ConnectionNot {
    public String title = "";
    public String version = "";
    public String copyright = "";
    public String author = "";
    public String date = "";
    public String editor = "";
    public String startTag = "";
    private int[][] notTagTable = null;
    private String[][] notMorphTable = null;
    private int ruleCount = 0;

    public boolean checkConnection() {
        return true;
    }

    public void clear() {
        this.title = "";
        this.version = "";
        this.copyright = "";
        this.author = "";
        this.date = "";
        this.editor = "";
        this.startTag = "";
        this.ruleCount = 0;
        this.notTagTable = null;
        this.notMorphTable = null;
    }

    public void init(String filePath, TagSet tagSet) throws IOException {
        this.readFile(filePath, tagSet);
    }

    private void readFile(String filePath, TagSet tagSet) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
        String line = null;
        ArrayList<String> ruleList = new ArrayList<String>();
        this.title = "";
        this.version = "";
        this.copyright = "";
        this.author = "";
        this.date = "";
        this.editor = "";
        this.startTag = "";
        this.ruleCount = 0;
        while ((line = br.readLine()) != null) {
            StringTokenizer lineTokenizer = new StringTokenizer(line, "\t");
            if (!lineTokenizer.hasMoreElements()) continue;
            String lineToken = lineTokenizer.nextToken();
            if (lineToken.startsWith("@")) {
                if ("@title".equals(lineToken)) {
                    this.title = lineTokenizer.nextToken();
                    continue;
                }
                if ("@version".equals(lineToken)) {
                    this.version = lineTokenizer.nextToken();
                    continue;
                }
                if ("@copyright".equals(lineToken)) {
                    this.copyright = lineTokenizer.nextToken();
                    continue;
                }
                if ("@author".equals(lineToken)) {
                    this.author = lineTokenizer.nextToken();
                    continue;
                }
                if ("@date".equals(lineToken)) {
                    this.date = lineTokenizer.nextToken();
                    continue;
                }
                if (!"@editor".equals(lineToken)) continue;
                this.editor = lineTokenizer.nextToken();
                continue;
            }
            if (!"CONNECTION_NOT".equals(lineToken)) continue;
            ruleList.add(lineTokenizer.nextToken());
        }
        this.ruleCount = ruleList.size();
        this.notTagTable = new int[this.ruleCount][2];
        this.notMorphTable = new String[this.ruleCount][2];
        Iterator iter = ruleList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String rule = (String)iter.next();
            StringTokenizer st = new StringTokenizer(rule, " ");
            this.notMorphTable[i][0] = st.nextToken();
            this.notTagTable[i][0] = tagSet.getTagID(st.nextToken());
            this.notMorphTable[i][1] = st.nextToken();
            this.notTagTable[i][1] = tagSet.getTagID(st.nextToken());
            ++i;
        }
        ruleList.clear();
        br.close();
    }
}

