/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.morph.WordEntry;
import org.apache.lucene.analysis.kr.utils.DictionaryUtil;
import org.apache.lucene.analysis.kr.utils.MorphUtil;
import org.apache.lucene.analysis.kr.utils.Utilities;

public class IrregularUtil {
    public static final char IRR_TYPE_BIUP = 'B';
    public static final char IRR_TYPE_HIOOT = 'H';
    public static final char IRR_TYPE_LIUL = 'U';
    public static final char IRR_TYPE_LOO = 'L';
    public static final char IRR_TYPE_SIUT = 'S';
    public static final char IRR_TYPE_DI = 'D';
    public static final char IRR_TYPE_RU = 'R';
    public static final char IRR_TYPE_UI = 'X';
    public static final char IRR_TYPE_REGULAR = 'X';

    public static String[] restoreIrregularVerb(String start, String end) throws MorphException {
        if (end == null) {
            end = "";
        }
        char[] jasos = new char[]{};
        if (end.length() > 0) {
            jasos = MorphUtil.decompose(end.charAt(0));
        }
        if (end.startsWith("\u3134")) {
            String[] irrs = IrregularUtil.restoreBIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreHIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreELIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
        } else if (end.startsWith("\u3139")) {
            String[] irrs = IrregularUtil.restoreBIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreHIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreELIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
        } else if (end.startsWith("\u3141")) {
            String[] irrs = IrregularUtil.restoreBIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreHIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
        } else if (end.startsWith("\u3142")) {
            String[] irrs = IrregularUtil.restoreBIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreHIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreELIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
        } else if (start.endsWith("\uc6b0") || start.endsWith("\uc624")) {
            String[] irrs = IrregularUtil.restoreBIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
        } else if (end.startsWith("\uc624")) {
            String[] irrs = IrregularUtil.restoreBIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
        } else if (end.startsWith("\uc2dc")) {
            String[] irrs = IrregularUtil.restoreBIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreELIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
        } else if (end.startsWith("\uc73c")) {
            String[] irrs = IrregularUtil.restoreBIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
        } else if (jasos.length > 1 && jasos[0] == '\u3147' && (jasos[1] == '\u3153' || jasos[1] == '\u314f')) {
            String[] irrs = IrregularUtil.restoreDIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreSIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreLIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreHIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreUIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreRUIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
        } else if (jasos.length > 1 && jasos[0] == '\u3147' && jasos[1] == '\u3161') {
            String[] irrs = IrregularUtil.restoreDIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
            irrs = IrregularUtil.restoreSIrregular(start, end);
            if (irrs != null) {
                return irrs;
            }
        } else if ("\uac00".equals(start) && "\uac70\ub77c".equals(end) || "\uc624".equals(start) && "\ub108\ub77c".equals(end)) {
            return new String[]{start, end};
        }
        return null;
    }

    private static String[] restoreBIrregular(String start, String end) throws MorphException {
        if (start == null || "".equals(start) || end == null) {
            return null;
        }
        if (start.length() < 2) {
            return null;
        }
        if (!start.endsWith("\uc624") && !start.endsWith("\uc6b0")) {
            return null;
        }
        char convEnd = MorphUtil.makeChar(end.charAt(0), 0);
        if ("\u3141".equals(end) || "\u3134".equals(end) || "\u3139".equals(end) || convEnd == '\uc544' || convEnd == '\uc5b4') {
            char ch = start.charAt(start.length() - 2);
            ch = MorphUtil.makeChar(ch, 17);
            WordEntry entry = DictionaryUtil.getVerb(start = start.length() > 2 ? Utilities.arrayToString(new String[]{start.substring(0, start.length() - 2), Character.toString(ch)}) : Character.toString(ch));
            if (entry != null && entry.getFeature(9) == 'B') {
                return new String[]{start, end};
            }
        }
        return null;
    }

    private static String[] restoreDIrregular(String start, String end) throws MorphException {
        if (start == null || "".equals(start)) {
            return null;
        }
        char ch = start.charAt(start.length() - 1);
        char[] jasos = MorphUtil.decompose(ch);
        if (jasos.length != 3 || jasos[2] != '\u3139') {
            return null;
        }
        ch = MorphUtil.makeChar(ch, 7);
        WordEntry entry = DictionaryUtil.getVerb(start = start.length() > 1 ? Utilities.arrayToString(new String[]{start.substring(0, start.length() - 1), Character.toString(ch)}) : Character.toString(ch));
        if (entry != null && entry.getFeature(9) == 'D') {
            return new String[]{start, end};
        }
        return null;
    }

    private static String[] restoreSIrregular(String start, String end) throws MorphException {
        if (start == null || "".equals(start)) {
            return null;
        }
        char ch = start.charAt(start.length() - 1);
        char[] jasos = MorphUtil.decompose(ch);
        if (jasos.length != 2) {
            return null;
        }
        ch = MorphUtil.makeChar(ch, 19);
        WordEntry entry = DictionaryUtil.getVerb(start = start.length() > 1 ? String.valueOf(start.substring(0, start.length() - 1)) + ch : Character.toString(ch));
        if (entry != null && entry.getFeature(9) == 'S') {
            return new String[]{start, end};
        }
        return null;
    }

    private static String[] restoreLIrregular(String start, String end) throws MorphException {
        if (start.length() < 2) {
            return null;
        }
        char ch1 = start.charAt(start.length() - 2);
        char ch2 = start.charAt(start.length() - 1);
        char[] jasos1 = MorphUtil.decompose(ch1);
        if ((jasos1.length == 3 && jasos1[2] == '\u3139' || jasos1.length == 2) && (ch2 == '\ub7ec' || ch2 == '\ub77c')) {
            StringBuffer sb = new StringBuffer();
            ch1 = MorphUtil.makeChar(ch1, 0);
            if (start.length() > 2) {
                sb.append(start.substring(0, start.length() - 2)).append(ch1).append("\ub974");
            } else {
                sb.append(Character.toString(ch1)).append("\ub974");
            }
            WordEntry entry = DictionaryUtil.getVerb(sb.toString());
            if (entry != null && entry.getFeature(9) == 'L') {
                return new String[]{sb.toString(), end};
            }
        }
        return null;
    }

    private static String[] restoreELIrregular(String start, String end) throws MorphException {
        if (start == null || start.length() == 0 || end == null || end.length() == 0) {
            return null;
        }
        if (end.charAt(0) != '\u3134' && end.charAt(0) != '\u3139' && end.charAt(0) != '\u3142' && end.charAt(0) != '\uc624' && end.charAt(0) != '\uc2dc') {
            return null;
        }
        char convEnd = MorphUtil.makeChar(start.charAt(start.length() - 1), 8);
        WordEntry entry = DictionaryUtil.getVerb(start = String.valueOf(start.substring(0, start.length() - 1)) + convEnd);
        if (entry != null) {
            return new String[]{start, end};
        }
        return null;
    }

    private static String[] restoreRUIrregular(String start, String end) throws MorphException {
        if (start.length() < 2) {
            return null;
        }
        char ch1 = start.charAt(start.length() - 1);
        char ch2 = start.charAt(start.length() - 2);
        char[] jasos1 = MorphUtil.decompose(ch1);
        char[] jasos2 = MorphUtil.decompose(ch2);
        if (jasos1[0] != '\u3139' || jasos2[0] != '\u3139') {
            return null;
        }
        ch2 = MorphUtil.makeChar(ch2, 0);
        WordEntry entry = DictionaryUtil.getVerb(start = start.length() > 2 ? start.substring(0, start.length() - 1) : Character.toString(ch2));
        if (entry != null && entry.getFeature(9) == 'R') {
            return new String[]{start, end};
        }
        return null;
    }

    private static String[] restoreHIrregular(String start, String end) throws MorphException {
        if (start == null || "".equals(start) || end == null || "".equals(end)) {
            return null;
        }
        char ch1 = end.charAt(0);
        char ch2 = start.charAt(start.length() - 1);
        char[] jasos1 = MorphUtil.decompose(ch1);
        char[] jasos2 = MorphUtil.decompose(ch2);
        if (jasos1.length == 1) {
            ch2 = MorphUtil.makeChar(ch2, 27);
        } else {
            if (jasos2.length != 2 || jasos2[1] != '\u3150') {
                return null;
            }
            ch2 = MorphUtil.makeChar(ch2, 0, 27);
        }
        start = start.length() > 1 ? String.valueOf(start.substring(0, start.length() - 1)) + ch2 : Character.toString(ch2);
        WordEntry entry = DictionaryUtil.getVerb(start);
        if (entry != null && entry.getFeature(9) == 'H') {
            return new String[]{start, end};
        }
        return null;
    }

    private static String[] restoreUIrregular(String start, String end) throws MorphException {
        if (start == null || "".equals(start)) {
            return null;
        }
        char ch = start.charAt(start.length() - 1);
        char[] jasos = MorphUtil.decompose(ch);
        if (jasos.length != 2 || jasos[1] != '\u3153') {
            return null;
        }
        ch = MorphUtil.makeChar(ch, 18, 0);
        WordEntry entry = DictionaryUtil.getVerb(start = start.length() > 1 ? String.valueOf(start.substring(0, start.length() - 1)) + ch : Character.toString(ch));
        if (entry != null) {
            return new String[]{start, end};
        }
        return null;
    }
}

