/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell.korean;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;

public class KoHangulSepllTokenizer
extends Tokenizer {
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 1024;
    private final char[] buffer = new char[255];
    private final char[] ioBuffer = new char[1024];
    private chType prevChType = chType.START;
    private int length;
    private int start;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private TypeAttribute typeAtt;

    public KoHangulSepllTokenizer(AttributeSource.AttributeFactory factory, Reader input) {
        super(factory, input);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public KoHangulSepllTokenizer(AttributeSource source, Reader input) {
        super(source, input);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public KoHangulSepllTokenizer(Reader input) {
        super(input);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    private final void push(char c) {
        if (this.length == 0) {
            this.start = this.offset - 1;
        }
        this.buffer[this.length++] = c;
    }

    private final boolean flush(chType curType) {
        if (this.length > 0) {
            this.termAtt.setTermBuffer(this.buffer, 0, this.length);
            this.offsetAtt.setOffset(this.correctOffset(this.start), this.correctOffset(this.start + this.length));
            this.typeAtt.setType(this.prevChType.name());
            this.prevChType = curType;
            return true;
        }
        this.prevChType = curType;
        return false;
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        this.length = 0;
        this.start = this.offset;
        block5: while (true) {
            ++this.offset;
            if (this.bufferIndex >= this.dataLen) {
                this.dataLen = this.input.read(this.ioBuffer);
                this.bufferIndex = 0;
            }
            if (this.dataLen == -1) {
                --this.offset;
                return this.flush(this.prevChType);
            }
            char c = this.ioBuffer[this.bufferIndex++];
            switch (Character.getType(c)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (this.processChr(chType.LETTER, c)) {
                        return this.flush(chType.LETTER);
                    }
                    this.prevChType = chType.LETTER;
                    continue block5;
                }
                case 5: {
                    if (this.processChr(chType.HANGUL, c)) {
                        return this.flush(chType.HANGUL);
                    }
                    this.prevChType = chType.HANGUL;
                    continue block5;
                }
                case 9: {
                    if (this.processChr(chType.NUMBER, c)) {
                        return this.flush(chType.NUMBER);
                    }
                    this.prevChType = chType.NUMBER;
                    continue block5;
                }
            }
            if (this.length > 0) {
                return this.flush(chType.START);
            }
            this.prevChType = chType.START;
        }
    }

    private final boolean processChr(chType curType, char curCh) {
        if (this.prevChType != curType && this.prevChType != chType.START) {
            if (this.length > 0) {
                --this.bufferIndex;
                --this.offset;
                return true;
            }
            this.push(curCh);
            return true;
        }
        this.push(curCh);
        return this.length == 255;
    }

    public final void end() {
        int finalOffset = this.correctOffset(this.offset);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public void reset() throws IOException {
        super.reset();
        this.dataLen = 0;
        this.bufferIndex = 0;
        this.offset = 0;
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum chType {
        NUMBER,
        LETTER,
        HANGUL,
        START,
        DEFAULT,
        END;

    }
}

