#include <Rcpp.h>
using namespace Rcpp;

// This is a simple example of exporting a C++ function to R. You can
// source this function into an R session using the Rcpp::sourceCpp 
// function (or via the Source button on the editor toolbar). Learn
// more about Rcpp at:
//
//   http://www.rcpp.org/
//   http://adv-r.had.co.nz/Rcpp.html
//   http://gallery.rcpp.org/
//

// [[Rcpp::export]]
NumericVector PV(NumericVector SE, int nlen) {
    
  int nlenp1 = nlen+1;
  NumericVector OutVec(nlenp1);
    
  for(int i=0; i<nlenp1; i++){
    if(i==0){
      OutVec[i] = SE[i]-1;
    }else if(i == nlen){
      OutVec[i] = SE[(nlen-1)]+1;
    }else{
      OutVec[i] = (SE[i-1]+SE[i])/2;
    }
    
  }

  
  return OutVec ;
}


// You can include R code blocks in C++ files processed with sourceCpp
// (useful for testing and development). The R code will be automatically 
// run after the compilation.
//

